#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// BallRollerMod01.fsh  by   Del  
//https://www.shadertoy.com/view/lltBRB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Ball roller - attempting to learn some raymarching techniques from the masters...
//
// raymarching base code from Shane's awesome 'Mountain Path' https://www.shadertoy.com/view/ldjyzc
// Del - 21/10/2018
//
// some slight mods: improved ball rolling, single box for rails, single texture etc.

#define FAR 120.
#define BALLSIZE 1.25
#define PI 3.14159
#define	TAU 6.28318

float objID;
float svObjID;
vec3 m_ballpos;		// ball position
mat3 m_ballmat;		// rotation matrix

// Fabrice's concise, 2D rotation formula.
//mat2 r2(float th){ vec2 a = sin(vec2(1.5707963, 0) + th); return mat2(a, -a.y, a.x); }

// Tri-Planar blending function. Based on an old Nvidia tutorial.
//vec3 tex3D( sampler2D t, in vec3 p, in vec3 n )
//{
//    p*=0.4;
//    n = max(abs(n), 0.001);
//    n /= dot(n, vec3(1));
//	vec3 tx = texture(t, p.yz).xyz;
//    vec3 ty = texture(t, p.zx).xyz;
//    vec3 tz = texture(t, p.xy).xyz;
//    return (tx*tx*n.x + ty*ty*n.y + tz*tz*n.z);
//}

// Smooth maximum, based on IQ's smooth minimum.
//float smax(float a, float b, float s){
//    
//    float h = clamp(.5 + .5*(a - b)/s, 0., 1.);
//    return mix(b, a, h) + h*(1. - h)*s;
//}

float smin( float a, float b, float k )
{
	float h = clamp( 0.5 + 0.5*(b-a)/k, 0.0, 1.0 );
	return mix( b, a, h ) - k*h*(1.0-h);
}

float sdBox( vec3 p, vec3 b )
{
    vec3 d = abs(p) - b;
    return min(max(d.x,max(d.y,d.z)),0.0) + length(max(d,0.0));
}

float sdSphere( vec3 p, float s )
{
    return length(p)-s;
}


vec3 rotateX(vec3 p, float a)
{
  float sa = sin(a);
  float ca = cos(a);
  return vec3(p.x, ca * p.y - sa * p.z, sa * p.y + ca * p.z);
}
//vec3 rotateY(vec3 p, float a)
//{
//  float sa = sin(a);
//  float ca = cos(a);
//  return vec3(ca * p.x + sa * p.z, p.y, -sa * p.x + ca * p.z);
//}
//vec3 rotateZ(vec3 p, float a)
//{
//  float sa = sin(a);
//  float ca = cos(a);
//  return vec3(ca * p.x - sa * p.y, sa * p.x + ca * p.y, p.z);
//}

// out: 0->val->0
float SmoothTri2(float t, float val)
{
    return val * (1.0-(0.5+cos(t*TAU)*0.5));
}

// Blended path(s)
vec2 path(in float z)
{ 
	float t = mod(z,68.0)/68.0;
	float m = SmoothTri2(t,1.0);
    vec2 path1 = vec2(sin(z*0.1)*0.5,(cos(z*0.2)*0.75)-1.0);
    vec2 path2 = vec2((sin(z*.15)*2.5), (cos(z*0.13)*1.25)+1.0); // Path 3.
    return mix(path1,path2,m);
}

// internal cylinder
float DirtyTunnel(vec3 p, float d)
{
	float d2 = d - length(p.xy);

    // tunnel noise...
    float k = dot(sin(p*1. - cos(p.yzx*1.57)), vec3(.333))*.57;
    k += dot(sin(p*2. - cos(p.yzx*3.14)), vec3(.333))*.13;
    d2-=k;
    return d2;
}


#if 0
// http://mercury.sexy/hg_sdf/
// Repeat space along one axis. Use like this to repeat along the x axis:
// <float cell = pMod1(p.x,5);> - using the return value is optional.
float pMod1(inout float p, float size)
{
	float halfsize = size*0.5;
	float c = floor((p + halfsize)/size);
	p = mod(p + halfsize, size) - halfsize;
	return c;
}

float hash(vec2 p)  // replace this by something better
{
    p  = 50.0*fract( p*0.3183099 + vec2(0.71,0.113));
    return fract( p.x*p.y*(p.x+p.y) );
}

float filth(in vec3 p, vec2 pth,float z)
{
    vec3 p2 = p;
    p2.xy += pth;
    
	float c = pMod1(p2.z,16.0);
    
    float r = hash(vec2(c+(c*0.31),c+(c*0.61)));

    if (r>0.6)
    {
        float h = 4.0;	// *r;
	    float dist3 = sdBox(p2-vec3(0.0,h-0.5,0.0),vec3(2.7,0.5,0.5));
	    p2.x -= 2.7;
	    float dist = sdBox(p2,vec3(0.5,h,0.5));
	    p2.x += 5.4;
	    float dist2 = sdBox(p2,vec3(0.5,h,0.5));
		dist=min(dist,dist2);
        
		//return smin(dist,dist3,0.9);
		return min(dist,dist3);
        
    }
    return 1.0;
}
#endif


float map(vec3 p)
{
    vec2 pth = path(p.z);

    // ROAD (1 box)
    vec3 pp2 = p;
    pp2.xy += pth;
    pp2.y += 3.0;		// road Yoffset
    float dist = sdBox(pp2,vec3(3.5,0.2,200000.0));
    
    // RAILS (1 box, abs mirror)
    pp2.x = abs(pp2.x);
    pp2.x -= 1.3;
    float rails = sdBox(pp2,vec3(0.125,0.5,200000.0));
    
    dist = smin(rails,dist,0.2);
    // debug
	//dist = smin(filth(p, pth, p.z),dist,0.2);    

    // + tunnel (-yoff)
    vec3 p2 = p;
    p2.xy += pth;
	float d2 = DirtyTunnel(p2-vec3(0.0,1.0,0.0),5.0);

    objID = step(d2, dist); // Tunnel, Ground...
    
    // Ball (hack)
    dist = smin(dist,d2,0.2);
    vec3 bp = p-m_ballpos;
	float balldist = sdSphere(bp,BALLSIZE);
    
	dist = min(balldist,dist);
    if (dist>=balldist)
        objID = 2.5;		// or Ball!
    if (dist>=rails)
        objID = 3.5;		// or Rail!
    
    return dist;
}

// Standard raymarching routine.
float trace(vec3 ro, vec3 rd)
{
    float t = 0., d;
    for (int i=0; i<160; i++)
    {
        d = map(ro + rd*t);
        if(abs(d)<.001*(t*.125 + 1.) || t>FAR)
            break;
        t += d;
    }
    return min(t, FAR);
}


float softShadow(vec3 ro, vec3 lp, float k, float t)
{
    const int maxIterationsShad = 48; 
    vec3 rd = lp-ro;
    float shade = 1.;
    float dist = .0025*(t*.125 + 1.);
    float end = max(length(rd), 0.0001);
    rd /= end;
    for (int i=0; i<maxIterationsShad; i++)
    {
        float h = map(ro + rd*dist);
        //shade = min(shade, k*h/dist);
        shade = min(shade, smoothstep(0.0, 1.0, k*h/dist));
        dist += clamp(h, .07, .5); 
        if (h<0.0 || dist > end)
            break; 
    }
    return min(max(shade, 0.) + 0.1, 1.); 
}

// Tetrahedral normal, to save a couple of "map" calls. Courtesy of IQ.
vec3 getNormal( in vec3 p )
{
    // Note the slightly increased sampling distance, to alleviate
    // artifacts due to hit point inaccuracies.
    vec2 e = vec2(0.0025, -0.0025); 
    return normalize(
        e.xyy * map(p + e.xyy) + 
        e.yyx * map(p + e.yyx) + 
        e.yxy * map(p + e.yxy) + 
        e.xxx * map(p + e.xxx));
}

float calcAO(in vec3 pos, in vec3 nor)
{
	float sca = 2.0, occ = 0.0;
    for( int i=0; i<5; i++ )
    {
        float hr = 0.01 + float(i)*0.5/4.0;        
        float dd = map(nor * hr + pos);
        occ += (hr - dd)*sca;
        sca *= 0.7;
    }
    return clamp( 1.0 - occ, 0.0, 1.0 );    
}

//vec3 BallTexture2(vec2 pos)
//{
//    float y = mod(pos.y+0.5,2.0)-0.5;
//	float s = smoothstep( y-0.5, y, 0.0) - smoothstep( y, y+0.5, 0.0); 
//    vec3 col = mix(vec3(0.7,0.5,0.8)*1.2,vec3(0.7,0.5,0.8)*0.5,s);
//    return col;
//}

vec3 BallTexture(vec2 pos)
{
    // lines
    float f = mod( floor(pos.y),2.0) + 0.75;
    vec3 col = f*vec3(0.7,0.5,0.8);
    return col;
}


// Coloring / texturing the scene objects, according to the object IDs.
vec3 getObjectColor(vec3 p, vec3 n)
{
    vec3 tx = vec3(1.0*1.0,0.98*0.98,0.95*0.95);
    
    if(svObjID<.5)
    {
        //vec2 pth = path(p.z);
        //tx = tex3D(texture0, (p - vec3(pth.xy - .5, .0)), n );	// Shane tex3d
        
        vec2 _uv = p.xz;
        _uv += path(p.z);
        tx = texture2D(texture0,_uv*0.1).xyz*vec3(0.8,1.1,0.8);
        tx*=tx;
        
    }
    else if(svObjID<1.5)
    {
        float scale = 0.25;
        p.xy += path(p.z);
        p*= scale;
        tx = texture2D(texture0, (vec2(p.z , atan(p.x, p.y)) / 6.28)).xyz;	// Cylinder
        tx*=tx;
    }
    else if(svObjID<2.6)
    {
        vec3 p2 = n;
        p2 = m_ballmat*p2;
        p2 = rotateX(p2,-m_ballpos.z);
        //p2 = normalize(p2);
        //p2 = rotateZ(p2,3.14/2.0);
        vec2 _uv;
        _uv.x = 0.5 + atan(p2.z, p2.x) / TAU;
        _uv.y = 0.5 - asin(p2.y) / PI;
		tx = BallTexture(_uv*7.0);					// sphere
		//tx = BallTexture2(_uv*5.0);				// sphere
    	//tx = texture(texture0, _uv*2.).rgb;
        tx*=tx;
    }
    return tx;
}

// Using the hit point, unit direction ray, etc, to color the scene. Diffuse, specular, falloff, etc. 
// It's all pretty standard stuff.
vec3 doColor(in vec3 ro, in vec3 rd, in vec3 lp, float t)
{
    // Initiate the scene (for this pass) to zero.
    vec3 sceneCol = vec3(0);
    
    if(t<FAR)
    { // If we've hit a scene object, light it up.
        
        // Surface hit point.
        vec3 sp = ro + rd*t;

        // Retrieving the normal at the hit point, plus the edge and curvature values.
        vec3 sn = getNormal(sp);
        
        // Shading. Shadows, ambient occlusion, etc. We're only performing this on the 
        // first pass. Not accurate, but faster, and in most cases, not that noticeable.
        // In fact, the shadows almost didn't make the cut, but it didn't quite feel 
        // right without them.
        float sh = softShadow(sp + sn*.002, lp, 16., t); // Set to "1.," if you can do without them.
        float ao = calcAO(sp, sn);
        sh = (sh + ao*.3)*ao;
        vec3 ld = lp - sp; // Light direction vector.
        float lDist = max(length(ld), 0.001); // Light to surface distance.
        ld /= lDist; // Normalizing the light vector.
        // Attenuating the light, based on distance.
        float atten = 3./(1. + lDist*0.01 + lDist*lDist*0.00008);
        // Standard diffuse term.
        float diff = max(dot(sn, ld), 0.);
        //diff = pow(diff, 2.)*.66 + pow(diff, 4.)*.34;
        // Standard specualr term.
        float spec = pow(max( dot( reflect(-ld, sn), -rd ), 0.0 ), 32.0);
        vec3 objCol = getObjectColor(sp, sn);
        // Combining the above terms to produce the final scene color.
        sceneCol = objCol*(diff + ao*.5 + vec3(1, .7, .5)*spec*1.);
        // Apply the attenuation and shadows.
        sceneCol *= atten*sh;
    }
    // Return the color. Done once for each pass.
    return sceneCol;
}


mat3 rotate3d(vec3 axis, float angle)
{
    //axis = normalize(axis);
    float s = sin(angle);
    float c = cos(angle);
    float oc = 1.0 - c;
    
    return mat3(oc * axis.x * axis.x + c,           oc * axis.x * axis.y - axis.z * s,  oc * axis.z * axis.x + axis.y * s, 
                oc * axis.x * axis.y + axis.z * s,  oc * axis.y * axis.y + c,           oc * axis.y * axis.z - axis.x * s, 
                oc * axis.z * axis.x - axis.y * s,  oc * axis.y * axis.z + axis.x * s,  oc * axis.z * axis.z + c);
}
mat3 lookat(vec3 o, vec3 t)
{
	vec3 dir = normalize(t-o);
    float yAxis = atan(dir.x,dir.z);
    float xAxis = -asin(dir.y);
    return rotate3d(vec3(1,0,0),xAxis)*rotate3d(vec3(0,1,0),yAxis);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    // Screen coordinates.
	vec2 uv = (fragCoord - iResolution.xy*.5)/iResolution.y;
	
	// Camera Setup.
	vec3 ro = vec3(0, 0, iTime*7.5); // Camera position, doubling as the ray origin.
    
    
	vec3 lk = ro + vec3(0.0, 0.0, 0.25);  // "Look At" position.
   
    // Light position.
    //vec3 lp = ro + vec3(10., FAR*.24, FAR*.52)*3.;
    vec3 lp = ro + vec3(10., FAR*.24, FAR*.22)*3.;
    
    m_ballpos = ro;
    vec3 BallLookAt = ro;

    // camera look ahead
    ro.xy-=path(ro.z);
    lk.xy-=path(lk.z);

    // position the ball infront of the camera (on the path)
    m_ballpos.z += 8.0;
    m_ballpos.y -= 1.5;
    m_ballpos.xy -= path(m_ballpos.z);
    
    BallLookAt.z += 8.05;
    //BallLookAt.y -= 1.5;
    BallLookAt.xy -= path(BallLookAt.z);
    BallLookAt.y = m_ballpos.y;
    
    m_ballmat = lookat(m_ballpos,BallLookAt);

    // Using the above to produce the unit ray-direction vector.
    float FOV = 3.14159/3.; // FOV - Field of view.
    vec3 forward = normalize(lk-ro);
    vec3 right = normalize(vec3(forward.z, 0., -forward.x )); 
    vec3 up = cross(forward, right);

    // rd - Ray direction.
    vec3 rd = (forward + FOV*uv.x*right + FOV*uv.y*up);
    rd = normalize(vec3(rd.xy, sqrt(max(rd.z*rd.z - dot(rd.xy, rd.xy)*.15, 0.)) ));
    
    // Trace the scene.    
    float t = trace(ro, rd);
    
    svObjID = objID; // Save the object ID, for use in the coloring equation.
    
    // Retrieving the color at the initial hit point.
    vec3 sceneColor = doColor(ro, rd, lp, t);
    
    // APPLYING FOG
    // Fog - based off of distance from the camera.
    float fog = smoothstep(0., .95, t/FAR); // t/FAR; 
    
    vec3 fogCol = vec3(0.5,0.5,0.5);
    sceneColor = mix(sceneColor, fogCol, fog); // exp(-.002*t*t), etc. fog.zxy 

    // Clamping the scene color, then presenting to the screen.
	fragColor = vec4(sqrt(clamp(sceneColor, 0.0, 1.0)), 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

