#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//distortMod01.fsh  by   Del
//https://www.shadertoy.com/view/3ssGDB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// distort - Catzpaw snow + distort

float N21(vec2 p) {
	vec3 a = fract(vec3(p.xyx) * vec3(213.897, 653.453, 253.098));
    	//a += dot(a, a.yzx + 79.76);
    	return fract((a.x + a.y) * a.z);
}
mat2 rot2(float a )
{
	float c = cos( a );
	float s = sin( a );
	return mat2( c, -s, s, c );
}

float Mtime(float mval)
{
    return mod(iTime,mval);
}

float TimerInOut(vec4 v)
{
    return smoothstep(v.y,v.y+v.w,v.x) - smoothstep(v.z-v.w,v.z,v.x);
}

// uv -1 <-> 1
float snow(vec2 uv,float scale)
{
	uv *= scale;
	uv.xy += iTime;
	vec2 gridIndex=floor(uv);
	vec2 posInGrid=fract(uv);
	vec2 pos = .5 + .35 * sin(11. * fract(sin((gridIndex + scale) * mat2(7,3,6,5)) * 5.)) - posInGrid;
	float k = length(pos);
	k = smoothstep(0., k, sin(posInGrid.x + posInGrid.y) * 0.02);
    return k;
}

vec3 _snow(vec2 uv)
{
    float time=iTime;
    // mods...
	uv.x += sin(time*1.5)*0.3;
	uv.y += cos(time*1.5)*0.3;
	uv*=0.5+sin(time)*0.2;
	float d = log(length(uv));
	d = (d*d);

    // smoother mod...
	float dmod = TimerInOut(vec4(Mtime(10.0),0.0, 9.5, 2.8));    
    d*=dmod;
    
	uv *= rot2(d);
    // snow...
	float c = 0.;
	c+=snow(uv,30.)*.3;
	c+=snow(uv,20.)*.5;
	c+=snow(uv,15.)*.8;
	c+=snow(uv,10.);
	c+=snow(uv,8.);
	c+=snow(uv,6.);
	c+=snow(uv,5.);
	c+=snow(uv,3.);
    return vec3(c*1.2,c*0.75,c*0.35) * d;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv=(fragCoord.xy*2.-iResolution.xy)/min(iResolution.x,iResolution.y); 
    fragColor = vec4(_snow(uv),1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

