#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//Apollonian_Mod01.fsh   by  EvilRyu   
//https://www.shadertoy.com/view/Mt2fzR
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by evilryu - evilryu/2017
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
//

vec2 rot(vec2 p, float r)
{
    vec2 q;
    q.x = p.x * cos(r) - p.y * sin(r);
    q.y = p.x * sin(r) + p.y * cos(r);
    return q;
}

vec3 apollonian(vec2 p)
{
    p = rot(p, iTime*0.1);

    float scale = 1.0;
    float t0 = 1e20, t1 = 1e20;
    for(int i = 0; i < 4; ++i)
    {
        p = -1.0 + 2.0*fract(p*0.5+0.5);
        float k=(1.34)/dot(p,p);
        p*=k;
        
        t0 = min(t0, dot(p,p));
        t1 = min(t1, max(abs(p.x), abs(p.y)));
        scale*=k;

    }
    float d=0.25*abs(p.y)/scale;
    d=smoothstep(0.001, 0.002,d);
    
    float c0=pow(clamp(t0, 0.0, 1.0), 1.5); 
    float c1=pow(clamp(t1, 0.0, 1.0), 2.);
    vec3 col0=0.5+0.5*sin(1.0+3.4*c0+vec3(2.,1.3, 0.)); 
	vec3 col1=0.5+0.5*sin(3.7*c1+vec3(2.,1.5, 0.)); 

    vec3 col = sqrt(d*col1*col0)*3.;
    
    return col;
}


vec2 getsubpixel(int id,vec2 fragCoord)
{
	vec2 aa=vec2(floor((float(id)+0.1)*0.5),mod(float(id),2.0));
	return vec2((2.0*fragCoord.xy+aa-iResolution.xy)/iResolution.y);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 q = fragCoord.xy / iResolution.xy;
    vec2 p = q * 2.0 - 1.0;
    p.x *= iResolution.x/iResolution.y;
    
    vec3 col = vec3(0.0);
    for(int i=0;i<4;++i)
    {
        vec2 p = getsubpixel(i,fragCoord);
        p*=exp(sin(iTime*0.2)*0.2);
        col += apollonian(p);
    }
    col/=4.0;
    col=col*0.6+0.4*col*col*(3.0-2.0*col);  // contrast
   	col*=0.5+.5*pow(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y),0.25);  // vigneting
	fragColor.xyz = col;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

