#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// LatticeWithFoldingMod01.fsh  by  EvilRyu   
//https://www.shadertoy.com/view/XsyczV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
// Created by evilryu
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.
// Continue playing with folding lattice, code is not interesting.

#define PI 3.14159265

float smin(float a, float b, float k)
{
    float h = clamp(0.5+0.5*(b-a)/k,0.,1.);
    return mix(b,a,h)-k*h*(1.-h);
}

vec4 texcube(sampler2D sam, vec3 p, vec3 n)
{
    vec4 p1=texture(sam, p.xy);
    vec4 p2=texture(sam, p.xz);
    vec4 p3=texture(sam, p.yz);
    return p1*abs(n.z)+p2*abs(n.y)+p3*abs(n.x);
}

float bump(vec3 p, vec3 n)
{
    return dot(texcube(texture0, 0.2*p, n).xyz, vec3(0.299, 0.587, 0.114)); 
}

vec3 bump_mapping(vec3 p, vec3 n, float weight)
{
    vec2 e = vec2(2./iResolution.y, 0); 
    vec3 g=vec3(bump(p-e.xyy, n)-bump(p+e.xyy, n),
                bump(p-e.yxy, n)-bump(p+e.yxy, n),
                bump(p-e.yyx, n)-bump(p+e.yyx, n))/(e.x*2.);  
    g=(g-n*dot(g,n));
    return normalize(n+g*weight);
}

vec3 path(float p)
{
    return vec3(sin(p*0.05)*cos(p*0.05)*18., 0.,0.);
}

// folding from gaz: https://www.shadertoy.com/view/4tX3DS
vec2 fold(vec2 p, float a)
{
    p.x=abs(p.x);
    vec2 n = vec2(cos(a),sin(a));
    for(int i = 0; i < 3; ++i)
    {
        p -= 2.*min(0.,dot(p,n))*n;
        n = normalize(n-vec2(1.,0.));
    }
    return p;
}

mat2 rot(float t)
{
    float c=cos(t);
    float s=sin(t);
    return mat2(c,-s,s,c);
}

float infi_box(vec3 p, vec2 b)
{
    vec2 d = abs(p.xy) - b;
    return min(max(d.x, d.y), 0.0) + length(max(d,0.0));
}

int mateid=0;

float map(vec3 p)
{
    p-=path(p.z);
    vec3 q=p;
    p=vec3(rot(0.05*p.z)*p.xy, p.z);
    p.xy=fold(p.xy,PI/3.);
    p=mod(p,2.)-1.;

    // variation of BCC lattice from paniq: https://www.shadertoy.com/view/llfGRj
    vec3 o = abs(p); 
    o-=(o.x+o.y+o.z)*0.33333;
    float d0=max(o.x,max(o.y,o.z))-0.03;
    float d1=length(q.xy)-1.;
    d0=max(d0,-d1);
    
    mateid=0;
    
    float d2=infi_box(q+vec3(0.,1.2,0.),vec2(1.5,0.1+0.06*texture2D(texture1,0.1*q.xz).x));
  	float d3=d1-4.;
    if(d2<d0) mateid=1;
    
    d0=smin(d0,d2,0.5);
    
    if(-d3<d0) mateid=2;
    
    // warped by a tunnel
    d0=smin(d0,-d3,0.5);
    
    return d0;
}

vec3 get_normal(vec3 p)
{ 
    vec3 e=vec3(0.001,0.0,0.0); 
    return normalize(vec3(map(p+e.xyy)-map(p-e.xyy), 
                          map(p+e.yxy)-map(p-e.yxy), 
                          map(p+e.yyx)-map(p-e.yyx))); 
} 

float intersect(vec3 ro, vec3 rd)
{
    float t=0.01;
    float d=map(ro+t*rd);
    for(int i=0;i<128;++i)
    {
        if(abs(d)<0.002||t>100.)
            continue;
        t+=d;
        d=map(ro+t*rd);
    }
    if(t>100.)t=-1.;
    return t;
}

vec3 hash3(float n)
{
    return fract(sin(vec3(n,n+1.0,n+2.0))*vec3(43758.5453123,22578.1459123,19642.3490423));
}

// curvature from iq: https://www.shadertoy.com/view/MsXGzM
float curvature(vec3 p, vec3 n)
{
    float acc=0.0;
    for(int i=0;i<4;i++)
    {
        vec3 aopos=normalize(hash3(float(i)*213.47));
        aopos=aopos-dot(n,aopos)*n;
        aopos=p+aopos*0.07;
        float dd=clamp(map(aopos)*100.0, 0.0, 1.0 );
        acc+=dd;
    }
    return smoothstep(0.2, 1.0, acc/4.0);
}

float shadow(vec3 ro, vec3 rd, float dist)
{
    float res=1.0;
    float t=0.05;
    float h;
    
    for(int i=0;i<12;i++)
    {
        // break still breaks on my windows.
        if(t>dist) continue;
        h=map(ro+rd*t);
        res = min(6.0*h/t, res);
        t+=h;
    }
    return max(res, 0.0);
}

vec3 light_source(vec3 spot_light, vec3 dir, float dis)
{
    float g = 0.0;
    if (length(spot_light) < dis)
    {
		g = pow(max(dot(normalize(spot_light), dir), 0.0), 600.0);
    }
    return vec3(1.6,1.2,1.) * g;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 q=fragCoord.xy/iResolution.xy;
    vec2 p=q*2.-1.;
    p.x*=iResolution.x/iResolution.y;

    vec3 ro=vec3(0.,0.,-iTime);
    vec3 ta=ro+vec3(0,0,-1.);
    
    vec3 lp0=ro+vec3(0,0.2,-3);
    
    ro+=path(ro.z);
    ta+=path(ta.z);
    lp0+=path(lp0.z-1.*(.5+.5*sin(iTime)));
    
    vec3 f=normalize(ta-ro);
    vec3 r=normalize(cross(f,vec3(0,1,0)));
    vec3 u=normalize(cross(r,f));
    
    vec3 rd=normalize(mat3(r,u,f)*vec3(p.xy,1.717));
    vec3 col=vec3(0.6,0.8,1.1);

    float t=intersect(ro,rd);
    if(t>-0.5)
    {
        vec3 pos=ro+t*rd;
        vec3 n=get_normal(pos);
        
        vec3 mate=texcube(texture0, pos, n).xyz*vec3(0.5,0.7,1.);
        float cur = curvature(pos, n);
        
        mate += cur*vec3(1.);
        vec3 tex=texture2D(texture1,pos.xz).xyz;
        if(mateid==1)
        {
            mate=.5*vec3(.6*tex.x,.8*tex.x,1.*tex.x);
            n=bump_mapping(pos, n, 0.2/(1.+t*0.4));
        }
        else if(mateid==2)
        {
            mate=2.*vec3(0.5,.6, .6);
            n=bump_mapping(pos, n, 0.2/(1.+t*0.4));
        }
        
        if(mateid!=1)
       	mate=mix(mate,mate*tex,smoothstep(2.5,-1.,pos.y));
        
        vec3 ld0=lp0-pos;
        float ldist=length(ld0);
        ld0/=ldist;
        vec3 lc0=2.*vec3(1.2,0.8,0.5);
        
        float sha=shadow(pos+0.01*n, ld0, ldist);
        float dif=max(0.,dot(n,ld0))*sha;
        float bac=max(0.,dot(n,-ld0));
        float amb=max(0.,dot(n,vec3(0,1,0)))*max(0.,(pos.y+1.));
        float spe=max(0.0, pow(clamp(dot(ld0, reflect(rd, n)), 0.0, 1.0), 32.0));
        
        vec3 Lo=10.*dif*lc0/(1.5*ldist);
        Lo+=2.*amb*vec3(0.5,0.8,1.0);    
        Lo+=0.5*bac*lc0;
        Lo+=2.*spe*vec3(1.);
        
        Lo*=clamp(pos.y+1.8,0.0,1.);
        
        col=mate*Lo*0.2;
    }
    col=mix(col, 0.5*vec3(0.6,0.8,1.1), 1.0-exp(-0.005*t*t) );
    col += light_source(lp0-ro, rd, 10.);
    
    col=pow(clamp(col,0.0,1.0),vec3(0.45));    
    col=pow(col,vec3(0.95,.95,0.9));
    col*=pow(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y), 0.1);
    fragColor.xyz=col;
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

