#version 140
#extension GL_EXT_gpu_shader4 : enable
//MeadowMod01.fsh by Hei149
//https://www.shadertoy.com/view/wsscW2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define pi 3.141592

mat2 rotate(float ang)
{
    float ca = cos(ang), sa = sin(ang);
    return mat2(ca, sa, -sa, ca);
}

float sdBox(vec3 p, vec3 b)
{
    vec3 h = abs(p) - b;
    return length(max(h, 0.0)) - min(max(h.x, max(h.y, h.z)), 0.0);
}


float rand(vec2 uv)
{
    return fract(sin(dot(uv, vec2(12.4392, 44.4393))) * 95.549) * 2.0 - 1.0;
}

float rnd2(vec2 uv) {
  return fract(dot(sin(uv*427.512+uv.yx*652.477),vec2(417.884)));
  
}

float noise(vec2 p)
{
    vec2 uv = fract(p);
    uv = uv * uv * (3.0 - 2.0 * uv);
    p = floor(p);
    return mix(
        mix(rand(p), rand(p + vec2(1.0, 0.0)), uv.x),
        mix(rand(p+vec2(0.0, 1.0)), rand(p + vec2(1.0)), uv.x),
        uv.y
    );
}

float grass(vec3 p, float s)
{
  p /= s;
  p.y -= 2.0;
  float d = sdBox(p, vec3(sin(p.y + 2.0) * 0.1, 2.0, 0.01));
  return (d * s);
}

float meadow(vec3 p, float rep)
{
    vec2 id = floor(p.xz / rep);
    p.xz = mod(p.xz, rep) - 0.5 * rep;
    float scale = rnd2(id);
    float d = grass(p, 1.0 + scale * 1.5);
    return d;
}


float map(vec3 p)
{
  p.y += noise(p.xz * 0.02 + 20.) * 10.;
  p.x += sin(p.y * 0.548 + iTime) * 0.5;
  p.x += sin(p.y * 0.25 + iTime) * 0.6;
  p.z += sin(p.y * 0.248 + iTime) * 0.8;
  p.z += sin(p.y * 0.5 + iTime * 2.0) * 0.4;
  float d = meadow(p, 2.0);
  p.xz *= rotate(0.94);
  p.x += 1.0;
  d = min(d, meadow(p, 2.0));
  p.z += 1.0;
  p.xz *= rotate(-0.343);
  d = min(d, meadow(p, 2.0));
  p.xz += 1.8;
  p.xz *= rotate(1.84);
  d = min(d, meadow(p, 2.0));
  
  return min(d, p.y);
}

float shadow(vec3 p, vec3 ld)
{
    float shadow = 1.0;
    float d = 0.03;
    for(int i = 0; i < 32; ++i)
    {
        float t = map(p + d * ld);
        d += t;
        shadow = min(shadow, t/d * 30.0);
    }
    return clamp(shadow, 0.0, 1.0);
}

float sss(vec3 p, vec3 l, float d)
{
    return smoothstep(0.0, 1.0, map(p + d * l) / d);
}

vec3 norm(vec3 p)
{
    vec2 e = vec2(0.001, 0.0);
    return normalize(vec3(
        map(p + e.xyy) - map(p - e.xyy),
        map(p + e.yxy) - map(p - e.yxy),
        map(p + e.yyx) - map(p - e.yyx)
    ));
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    vec2 uv = (gl_FragCoord.xy - 0.5 * iResolution.xy) / iResolution.y;
    vec3 r0 = vec3(0.0, 40.0, -90.0);
    r0.xz *= rotate(0.5);
    vec3 tgt = vec3(0.0);
    r0.z += iTime * 20.0;
    tgt.z += iTime * 20.0;
    vec3 ww = normalize(tgt - r0);
    vec3 uu = normalize(cross(vec3(0,1,0), ww));
    vec3 vv = normalize(cross(ww, uu));

    float zoom = 1.0;
    vec3 rd = normalize(uv.x * uu + uv.y * vv + ww * zoom);

    float d = 0.0;
    vec3 col = vec3(0.0);
    
    for(int i = 0; i < 100; ++i)
    {
        vec3 p = r0 + d * rd;
        float t = map(p);
        d += t;
        if(t < 0.01 || d > 400.0)
	      break;
    }

    vec3 p = r0 + d * rd;
    float scatt = 0.0f;
    vec3 ld = normalize(vec3(0.5, 0.5, 0.5));
    float numStep = 10.0;
    for(float i = 1.0; i < numStep; ++i)
    {
        float dist = 8.0 * (i  / numStep);
        scatt += sss(p, ld, dist);
    }
    scatt *= 4.0 / numStep;
    col = scatt * mix(vec3(0.6, 0.3, 0.1), vec3(0.3, 0.6, 0.1), 0.5 + 0.5 * rand(p.xz * 0.5));
    vec3 n = norm(p);
    float fog = (1.0 - (clamp(d / 400.0, 0.0, 1.0)));
    col *= fog;
    vec3 sky =  mix(vec3(0.5, 0.7, 1.0), vec3(0.9, 0.7, 0.1), max(0.0, pow(dot(rd, ld),2.0)));
    col += pow((1.0f - fog), 4.0) * sky;
    col = pow(col, vec3(0.4545));
    gl_FragColor = vec4(col, 1.0);
}





