#version 140
#extension GL_EXT_gpu_shader4 : enable
// NoodlePanicMod01.fsh  by Hirai_worthless
//https://www.shadertoy.com/view/Wl2XW3
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float PI = 3.14159265;
mat2 genRot(float a){
	return mat2(cos(a),-sin(a),sin(a),cos(a));
}
vec2 pmod(vec2 p,float count){
	p *= genRot(PI/count);
	float at = atan(p.y/p.x);
	float r = length(p);
	at = mod(at,2. * PI / count);
	p = vec2(r * cos(at),r * sin(at));
	p *= genRot(-PI/count);
	return p;
}
float map(vec3 p){
    p = fract(p + 0.5)-0.5;
    vec3 q = p;
    float cube = min(length(q.xz + sin(q.y *2.*PI + iTime) * 0.1) - 0.05,length(q.yz - sin(q.x *2.*PI+ iTime) * 0.1 ) - 0.05);
    cube = min(cube,length(q.xy + sin(q.z *2.*PI + iTime) * 0.1 )- 0.05);
    //cube = min(cube,length(p)- 0.1);
    return cube;
}
vec3 getNormal(vec3 p){
	vec3 x = dFdx(p);
	vec3 y = dFdy(p);
	return normalize(cross(x,y));
}
vec4 trace(vec3 o,vec3 r){
	float t = 0.;
	vec3 p;
	for(int i = 0; i < 128; i++){
		p = o + r * t;
		float d = map(p);
		t += d * 0.75;
	}
	vec3 n = getNormal(p);
	return vec4(n,t);
}

vec3 cam(){
	vec3 c = vec3(.5,.5,-1.5 + iTime);
	return c;
}
vec3 ray(vec2 uv,float z){
	vec3 r = normalize(vec3(uv,z));
    r.xz *= genRot(PI/6.);
    r.yz *= genRot(PI/6.);
	return r;
}

vec3 getColor(vec3 o, vec3 r, vec4 d){
    vec3 n = d.xyz;
    float t = d.w;
    vec3 l = vec3(-1.);
    float s = dot(l,n);
    vec3 c;
    float fog = 1./(1. + t * t * 0.05);
    c = s < -0.8 ? vec3	(159,158,137)/255. : 
    (s > 0.8 ? vec3	(213,211,187)/255. : vec3(185,178,155)/255.);
    c = mix(vec3(55,15,8)/255.,c,fog);
    return c;
    
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = ( gl_FragCoord.xy * 2. - iResolution.xy) / iResolution.y ;
	vec3 c = cam();
	vec3 r = ray(uv,1.5);
	vec4 d = trace(c,r);
	vec3 color = getColor(c,r,d);

	gl_FragColor = vec4( color, 1.0 );

}