#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// RadiationMod01.fsh  by   KingHashish
//https://www.shadertoy.com/view/mdXXzN
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14159265358979323
#define hue(v) ( .6 + .6 * cos( 2.*PI*(v) + vec3(0,-2.*PI/3.,2.*PI/3.)))
#define ZOOM 250.

#define cmul(z1, z2) (mat2(z1, -z1.y, z1.x)*z2)
#define cdiv(z1, z2) (z1*mat2(z2, -z2.y, z2.x)/dot(z2, z2))



vec2 clog(vec2 z)
{
    vec2 w;
    
    w.x = 0.5*log(z.x*z.x + z.y*z.y);
    w.y = atan(z.y, z.x);
    
    return w;
}

vec3 hrgb(vec2 w)
{
    vec3 c, cc;
    float mm;
    float p;
    
    float m = length(w);
    float a = (PI + atan(w.y, -w.x))/(2.0*PI);
    
    m = log(1. + 100.*m);
    
    //cc = 0.;
    //cc.r =  0.5 - 0.5*sin(2.0*PI*a - PI/2.0 + a*m*100.);
   //cc.g = (0.5 + 0.5*sin(2.0*PI*a*1.5 - PI/2.0 + a*m*100.));// * float(a < 0.66);
    //cc.b = (0.5 + 0.5*sin(2.0*PI*a*1.5 + PI/2.0 + a*m*100.));// * float(a > 0.33);
    
    cc.r = 0.5 - 0.5*sin(2.0*PI*a - PI/2.0 + m*1.4 + 2.*iTime);
    cc.g = 0.5 - 0.5*sin(2.0*PI*a - PI/2.0 + m*1.4 + 2.*iTime);
    cc.b = 0.;
    
    
    //cc -= 0.1*m;
    //c = 0.5*(hue(a) + cc);
    c = cc;
    
    //mm = fract(m);
    //p = fract(mod(a, 1.0/16.0));
     
    //c -= 0.15*mm + 1.5*p;
    
    //if (/*length(w) + .05 > 1. &&*/
    //    (fract(w.x) < .05 || fract(-w.x) < .05 ||
    //     fract(w.y) < .05 || fract(-w.y) < .05)) c -= 0.5;
    
    return c;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{




    vec2 z, w, w1, w2, w3, w4;
    
    z = fragCoord - iResolution.xy/2.;
    
    
    if (iMouse.xy != vec2(0., 0.)) //to center at origin
        z -= iMouse.xy - iResolution.xy/2.;
    
    
    z /= ZOOM; //zoom

    //w = clog(z);
    w = cdiv(vec2(1.0, 0.), z);
    w =cdiv(w, z);
    w =cdiv(w, z);
    w =cdiv(w, z);
    w =cdiv(w, z);
    w =cdiv(w, z);

    
    
    
    
    w = cdiv(w, (z-0.5*vec2(1.,0.)));
     w = cdiv(w, (z-0.5*vec2(1.,0.)));
     w = cdiv(w, (z-0.5*vec2(1.,0.)));
     w = cdiv(w, (z-0.5*vec2(1.,0.)));
     
    
    w = cdiv(w, (z-0.5*vec2(2.,0.)));
    
    w = cdiv(w, (z-0.5*vec2(-1.,0.)));
    w = cdiv(w, (z-0.5*vec2(-1.,0.)));
    w = cdiv(w, (z-0.5*vec2(-1.,0.)));
    w = cdiv(w, (z-0.5*vec2(-1.,0.)));
    

    
    
    w = cdiv(w, (z-0.5*vec2(-2.,0.)));

    
        
    
    //w = cdiv(w, (z-vec2(1.,0.)));
    

    
   //w = z;            
    
    fragColor = vec4(hrgb(w), 1.0);
    

/*
    w1 = clog( z + vec2(-.25,-.25)/ZOOM );
    w2 = clog( z + vec2(-.25, .25)/ZOOM );
    w3 = clog( z + vec2( .25,-.25)/ZOOM );
    w4 = clog( z + vec2( .25, .25)/ZOOM );
    
    
    fragColor = vec4(0.25*(hrgb(w1) + hrgb(w2) + hrgb(w3) + hrgb(w4)), 1.0);
    */

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

