#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Trance1Mod01.fsh  by LAZARUSTARS    
//https://www.shadertoy.com/view/X3sfD4
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord * 2.0 - iResolution.xy) / iResolution.y;


    uv.x *= mix(0.6, 1.5, sin(iTime * 0.5));
    uv.y *= mix(0.8, 1.2, cos(iTime * 0.7));

    float angle = atan(uv.y, uv.x) + sin(iTime * 0.4);
    float radius = length(uv);
    radius = abs(sin(12.0 * radius+ iTime * 2.0)) * 0.8;
    angle += sin(iTime * 0.6) + cos(iTime * 0.9) * radius;

    float wave = sin(angle * 15.0 + cos(iTime * 0.8)) * 0.25 * sin(iTime * 1.5);
    float r = 0.4 + wave * cos(iTime * 0.6);

    vec3 col = vec3(
        0.5 + 0.5 * sin(iTime + angle),
        0.5 + 0.5 * cos(iTime + radius),
        0.7 + 0.3 * sin(angle * radius)
    );
    vec3 bgColor = mix(
        vec3(0.1, 0.05, 0.2),
        vec3(0.4, 0.3, 0.6),
        sin(iTime * 1.2 + uv.y + uv.x)
    ) * 0.8 + vec3(0.2, 0.15, 0.4) * cos(uv.x * 3.0 + uv.y * 3.0);

    float g = smoothstep(0.35, 0.4, radius -r) * 0.8 + pow(sin(iTime * 2.0 + radius * 20.0), 5.0) * 0.3;
    col += g * vec3(1.0, 0.8, 0.6);
    vec3 sparkles = vec3(1.0, 0.9, 0.7) * pow(sin(angle * 15.0 + iTime * 5.0), 20.0) * smoothstep(0.3, 0.4, radius);

    vec3 finalcolor = mix(bgColor, col+ sparkles, smoothstep(0.2, 0.5, r - radius));
    fragColor = vec4(finalcolor, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

