#version 330
#extension GL_EXT_gpu_shader4 : enable
//MapperMod01.fsh  by  Myro
//https://www.shadertoy.com/view/3sfSRn
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// 2D land map generator with 2 biomes and made using noise

// "vonronoise" from https://www.shadertoy.com/view/Xd23Dh
// More info here: https://iquilezles.org/articles/voronoise

// ell noise    u=0,v=0
// voronoi      u=1,v=0
// perlin noise u=0,v1=
// voronoise    u=1,v=1

vec3 hash3( vec2 p )
{
    vec3 q = vec3( dot(p,vec2(127.1,311.7)), 
				   dot(p,vec2(269.5,183.3)), 
				   dot(p,vec2(419.2,371.9)) );
	return fract(sin(q)*43758.5453);
}

float iqnoise( vec2 x, float u, float v )
{
    vec2 p = floor(x);
    vec2 f = fract(x);
		
	float k = 1.0+63.0*pow(1.0-v,4.0);
	
	float va = 0.0;
	float wt = 0.0;
    for( int j=-2; j<=2; j++ )
    for( int i=-2; i<=2; i++ )
    {
        vec2 g = vec2( float(i),float(j) );
		vec3 o = hash3( p + g )*vec3(u,u,1.0);
		vec2 r = g - f + o.xy;
		float d = dot(r,r);
		float ww = pow( 1.0-smoothstep(0.0,1.414,sqrt(d)), k );
		va += o.z*ww;
		wt += ww;
    }
	
    return va/wt;
}

float vonronoi(vec2 x) {
	return iqnoise(x,1.0,0.0);
}

float noise(vec2 x) {
	return iqnoise(x,0.0,1.0);
}

float vonronoise(vec2 x) {
	return iqnoise(x,1.0,1.0);
}

// vonronoi but with  intensity & contrast control
float vonronoiStep(float i, float a, float b, vec2 x) {
    float d = 0.2*(b-a);
	return 1.0-i+(smoothstep(a-d, b+d, vonronoi(x))*(i));
}

// noise but with  intensity & contrast control
float noiseStep(float i, float a, float b, vec2 x) {
    float d = 0.2*(b-a);
	return 1.0-i+(smoothstep(a-d, b+d, noise(x))*(i));
}

// vonronoise but with  intensity & contrast control
float vonronoiseStep(float i, float a, float b, vec2 x) {
    float d = 0.2*(b-a);
	return 1.0-i+(smoothstep(a-d, b+d, vonronoise(x))*(i));
}
// iq noise but with  intensity & contrast control
float iqStep(float i, float a, float b, float u, float v, vec2 x) {
    float d = 0.2*(b-a);
	return 1.0-i+(smoothstep(a-d, b+d, iqnoise(x, u, v))*(i));
}


/*
operations :
*	: more dark
/	: more light
max : only lighter
min : only darker
*/

float getHeight(vec2 uv) {
	float h = 0.0;
    // hills & valleys
    h = noiseStep(1.0,0.2,0.8,uv*0.2);
    h = max(h,0.8*noise((vec2(1000.0)+uv)*0.2));
    h = min(h,1.0*noise((vec2(100.0)+uv)*0.5));
    h = max(h,0.8*noise((vec2(800.0)+uv)*0.3));
    
    // seas
   	h *= 1.0-min(h,vonronoiseStep(0.5,0.6,0.65,0.1*uv));
	//continents
    h /= 1.8*vonronoiseStep(1.0,0.0,0.95,0.1*uv);
    
    // big seas
   	h *= 1.0-min(h,vonronoiseStep(0.5,0.6,0.65,0.03*uv));
	// big continents
    h /= 1.4*vonronoiseStep(1.0,0.0,0.95,0.03*uv);
    
    //rocky montain tops
   	h = min(h,(vonronoiseStep(0.05,-0.6,1.6,uv*0.01)));
    // random details stuff
   	h *= vonronoiseStep(0.3,-0.6,1.6,vec2(1500.0)+uv*0.8);
   	h /= vonronoiseStep(0.3,0.0,0.5,vec2(1500.0)+uv*0.1);
    h /= iqStep(0.21,-0.6,1.6,1.0,0.5,uv*1.1);
	
	return h;
}


//return a color from a to b when h goes from m to n (and divide the color by 255)
vec3 colormix (vec3 a, vec3 b, float h, float m, float n) {
    return mix(a/255.0, b/255.0, (h-m)/(n-m));
}
               
//return a color from a to b to c when h goes from m to n (and divide the color by 255)
vec3 tricolormix (vec3 a, vec3 b, vec3 c,float h, float m, float n) {
	float t = (h-m)/(n-m);
    if (t<0.5) {
    	return mix(a/255.0, b/255.0,t*2.0);
    }
    else {
    	return mix(b/255.0, c/255.0,(t-0.5)*2.0);
    }
}


vec3 biomeColor1 (float h) {

    //vec3 fog=vec3(197.0,219.0,211.0);
    float oceanh = 0.2;
    vec3 ocean1 =vec3(8.0,42.0,79.0);
    vec3 ocean2 =vec3(23.0,79.0,114.0);
    float seah = 0.32;
    vec3 sea1 =vec3(6.0,104.0,133.0);
    vec3 sea2 =vec3(56.0,104.0,133.0);
    float bayh = 0.4;
    vec3 bay1 =vec3(79.0,176.0,159.0);
    vec3 bay2 =vec3(93.0,204.0,167.0);
    float shoreh = 0.45;
    vec3 shore1 =vec3(131.0,246.0,191);
    vec3 shore2 =vec3(234.0,246.0,191);
    float beachh = 0.5;
    vec3 beach1 =vec3(210.0,173.0,128.0);
    vec3 beach2 =vec3(255.0,236.0,181.0);
    float fieldh = 0.74;
    vec3 field1 =vec3(31.0,122.0,4.0);
    vec3 field2 =vec3(140.0,191.0,28.0);
    float dirth = 0.92;
    vec3 dirt1 =vec3(154.0,148.0,9.0);
    vec3 dirt2 =vec3(204.0,170.0,31.0);
    float rockh = 0.97;
    vec3 rock1 =vec3(133.0,140.0,112.0);
    vec3 rock2 =vec3(72.0,114.0,104.0);
    vec3 snow1 =vec3(197.0,219.0,211.0);
    vec3 snow2 =vec3(224.0,255.0,255.0);

    if (h<oceanh)    	return colormix(ocean1, ocean2,h,0.0,oceanh);
    if (h<seah)     	return tricolormix(ocean2,sea1,sea2,h,oceanh,seah);
    if (h<bayh)         return tricolormix(sea2, bay1, bay2,h,seah,bayh);
    if (h<shoreh)       return tricolormix(bay2, shore1, shore2,h,bayh,shoreh);
    if (h<beachh)       return colormix(beach1, beach2,h,shoreh,beachh);
    if (h<fieldh)       return colormix(field1,field2,h,beachh,fieldh);
    if (h<dirth)        return tricolormix(field2, dirt1, dirt2,h,fieldh,dirth);
    if (h<rockh)        return tricolormix(dirt2, rock1, rock2,h,dirth,rockh);
	else/*snow*/		return tricolormix(rock2,snow1, snow2,h,rockh,1.0);	
}


vec3 biomeColor2(float h) {
    
    //vec3 fog=vec3(197.0,219.0,211.0);
    float oceanh = 0.2;
    vec3 ocean1 =vec3(8.0,42.0,79.0);
    vec3 ocean2 =vec3(23.0,79.0,114.0);
    float seah = 0.32;
    vec3 sea1 =vec3(6.0,104.0,133.0);
    vec3 sea2 =vec3(56.0,104.0,133.0);
    float bayh = 0.4;
    vec3 bay1 =vec3(79.0,176.0,159.0);
    vec3 bay2 =vec3(93.0,204.0,167.0);
    float shoreh = 0.45;
    vec3 shore1 =vec3(131.0,246.0,191);
    vec3 shore2 =vec3(234.0,246.0,191);
    float beachh = 0.5;
    vec3 beach1 =vec3(251.0,225.0,182.0);
    vec3 beach2 =vec3(247.0,237.0,222.0);
    float fieldh = 0.74;
    vec3 field1 =vec3(118.0,102.0,33.0);
    vec3 field2 =vec3(204.0,166.0,113.0);
    float dirth = 0.92;
    vec3 dirt1 =vec3(103.0,76.0,14.0);
    vec3 dirt2 =vec3(156.0,79.0,32.0);
    float rockh = 0.97;
    vec3 rock1 =vec3(71.0,68.0,62.0);
    vec3 rock2 =vec3(115.0,136.0,160.0);
    vec3 snow1 =vec3(89.0,96.0,88.0);
    vec3 snow2 =vec3(117.0,127.0,116.0);

    if (h<oceanh)    	return colormix(ocean1, ocean2,h,0.0,oceanh);
    if (h<seah)     	return tricolormix(ocean2,sea1,sea2,h,oceanh,seah);
    if (h<bayh)         return tricolormix(sea2, bay1, bay2,h,seah,bayh);
    if (h<shoreh)       return tricolormix(bay2, shore1, shore2,h,bayh,shoreh);
    if (h<beachh)       return colormix(beach1, beach2,h,shoreh,beachh);
    if (h<fieldh)       return colormix(field1,field2,h,beachh,fieldh);
    if (h<dirth)        return tricolormix(field2, dirt1, dirt2,h,fieldh,dirth);
    if (h<rockh)        return tricolormix(dirt2, rock1, rock2,h,dirth,rockh);
	else/*snow*/		return tricolormix(rock2,snow1, snow2,h,rockh,1.0);	
}


float getBiome(vec2 uv) {
    return noiseStep(1.0,0.45,0.55,0.01*uv);
	
}
vec3 getColor (vec2 uv, float h) {
    float b = getBiome(uv);
    return colormix( 255.0*biomeColor1(h),  255.0*biomeColor2(h), b,0.0,1.0);
}

const float SCALE = 800.0;
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized screen pixel coordinates (from -1 to 1)
    vec2 uv = (gl_FragCoord.xy/iResolution.xy-0.5)*2.0;
    
    vec4 mouse = iMouse / iResolution.x;
    float scale = SCALE*mouse.y;
    if (mouse.y <= 0.0) scale = 100.0;
    float offset = (mouse.x);
    
    vec2 mapuv = uv;// coordinate on the map
    mapuv *= scale;
    mapuv += vec2(cos(0.01*iTime*pow(scale,0.2)+offset), sin(0.01*iTime*pow(scale,0.2)+offset))*10.0*scale;
	float height = getHeight(mapuv);
    
    // vignette & vertical gradient
    float postfx = 0.05*(uv.y)-0.02*length(uv)*length(uv);
    // Output to screen
    gl_FragColor = vec4(getColor(mapuv, height) + postfx,1.0);
}