#version 130
#extension GL_EXT_gpu_shader4 : enable
// zooooooooomMod01.fsh  by   Plento

//https://www.shadertoy.com/view/wdj3Wc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Plento

#define FAR 60.0
#define DISTANCE_BIAS 0.75

mat2 rot(float a) {
    return mat2(cos(a), -sin(a), sin(a), cos(a));
}


float map(vec3 rp)
{
    vec3 pos = rp - vec3(0.0, 0.0, 0.0);
    vec3 b = vec3(1.9);
    
    pos.x += sin(pos.z + iTime*0.6)*0.56;
    pos.y += cos(pos.z + iTime*0.6)*0.56;
    
    pos = mod(pos, b)-0.5*b;
    
    float res = length(pos)-0.5;
    
    return res;
}
vec3 getNormal(vec3 p)
{
    vec2 e = vec2(0.0035, -0.0035); 
    return normalize(
        e.xyy * map(p + e.xyy) + 
        e.yyx * map(p + e.yyx) + 
        e.yxy * map(p + e.yxy) + 
        e.xxx * map(p + e.xxx));
}

vec3 color(vec3 ro, vec3 rd, vec3 norm, float t)
{
    vec3 lp = ro + vec3(0.0, 0.0, -1.0) * 10.; 
    
	vec3 ld = normalize(lp - (ro + rd*t));
    
    vec3 p = (ro + rd * t);
    
    vec3 pb = mod(p, vec3(8))-0.5*vec3(8);
    
    // color stuff
    float diff = max(dot(norm, ld), 0.0);
    
    vec3 oCol = mix(vec3(1.0, 0.0, 0.0), vec3(1.0, 1.0, 1.0), pb);
    
    vec3 col;
    
    col = oCol*diff;
    
    return col;
    
}



vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = 1.1 * vec2(fragCoord.xy - 0.5*iResolution.xy)/iResolution.y; 
   
    vec3 ro = vec3(0.0, 0.0, -3.0); 
    vec3 rd = normalize(vec3(uv,2.0));
    
    rd.xy *= rot(iTime*0.15);
    ro.z += iTime*1.4;
    
    
    // march stuff
    float t = 0.0; 
    float d; 
    
    
    // glow stuff
    float minDist = 999.0; 
  
    vec3 glowCol = vec3(0);
    
    float g = 1.0;
    
    vec3 bg = vec3(0.4, 0.4, 0.1);
    
    float fog = 0.0;
    
    float oWidth = 0.2;
    float softness = 0.4;
    
    // march
    for (int i = 0; i < 31; i++)
    {
        d = map(ro + rd*t);
        
        minDist = min(minDist, d); 
        minDist = clamp(minDist, 0.02, d); 
        if(abs(d)<0.003) 
        {
            minDist = abs(d);
            break;  
        }
        if(t>FAR) 
        {
            minDist = min(minDist, d);
            t = FAR;
            break;
        }
        
        t += d * DISTANCE_BIAS;
        
        // Add Glow
        if(d > minDist && abs(d) > 0.15)
        {
            fog = smoothstep(0.41, 0.0, t / FAR);
            
            glowCol += vec3(0.6, 0.0, 0.0) 
                * smoothstep(oWidth,oWidth-softness, minDist) * fog
                   ;
            g++;
        }
    }
    
   
    glowCol /= g;
    
    vec3 col = vec3(0); 
    
    vec3 norm = getNormal(ro + rd * t); 
   
    col = color(ro, rd, norm, t);
    
    col += glowCol*80.0;
    
    // crap reflection
    ro += rd*t;
    
    rd = reflect(rd, norm);
    
    float rt = 0.0;
    d = 0.0;
    for (int i = 0; i < 25; i++)
    {
    	d = map(ro + rd * rt);
    	
        if(abs(d) < 0.0001)
        {
         	break;   
        }
        if(rt > FAR)
        {
         	break;   
        }
        
        rt += d;
        
    }
    
    norm = getNormal(ro + rd * rt); 
    
   
    col *= mix(col, color(ro, rd, norm, rt), 0.6);
    col = mix( col, vec3(0.0,0.0,0.9), 1.0 - exp( -0.0003*t*t*t ) );
    col = mix( col, vec3(0), 1.0 - exp( -0.01*rt*rt*rt ) );
    
    col /= 5.0;
    
    
         
    fragColor = vec4(sqrt(clamp(col, 0.0, 1.0)), 1.0);
 return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.