#version 330
#extension GL_EXT_gpu_shader4 : enable
//SimpleStarsMod01.fsh by  Trisomie21
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177  //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float Cell(vec2 c) {
	vec2 uv = fract(c);c -= uv;
	return (1.-length(uv*2.-1.)) * step(fract(sin(c.x+c.y*1e2)*1e3), .04);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord ) 
{

	vec2 p = gl_FragCoord.xy / iResolution.xy -.5;
	float a = fract(atan(p.x, p.y) / 6.2832);
	float d = length(p);
	
	vec2 coord = vec2(pow(d, .04), a)*256.;
	vec2 delta = vec2(1. + iTime*20., 1.);
	
	float c = Cell(coord-=delta);
	c += Cell(coord-=delta);
	
	gl_FragColor = vec4(c*d*3.);
}