#version 330
#extension GL_EXT_gpu_shader4 : enable
// FireplaceMod01.fsh  by   _polymath

//https://www.shadertoy.com/view/ldKfWy
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float flameWidth = 0.06,
        numberOfFlames = 500.0,
        swayAmount = 0.4,
        swaySpeed = 0.2,
        moveSpeed = 0.2,
        patchHeight = 0.4,
        redness = 2.0,
        yellowness = 0.8,
        whiteness= 0.5;
    
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    float x = uv.x * 1.4 - 0.4;
    
    float h = 0.0;
    
    for (float i = 0.0; i < numberOfFlames; ++i) {
        // how far across is this flame?
        float xx = mod(i * 744.44, 1.0) * mod(i * 434.64, 1.0);
        // make them move
        xx += cos(iTime * 0.4632 * mod(1324.34 * i, 0.2) + 412.523 * i) * moveSpeed;
        // make them wave from side to side
        xx += sin(uv.y * swayAmount) * cos(i * 64534.34) * swaySpeed;
        // combine them all
        h += max(0.0,
           (1.0 - uv.y)
                * (flameWidth - abs(x - xx))
                 * max(0.0, cos((uv.y - iTime) * (mod(1324.34 * i, 10.5) + patchHeight)))
        );
    }  
    
    gl_FragColor = vec4(h * redness, h * yellowness, h * whiteness, 1.0);
}