#version 140
#extension GL_EXT_gpu_shader4 : enable
//ElevationMod01.fsh  by arthursw
//https://www.shadertoy.com/view/lsXSzH
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// I've not seen anybody out there computing correct cell interior distances for Voronoi
// patterns yet. That's why they cannot shade the cell interior correctly, and why you've
// never seen cell boundaries rendered correctly. 
//
// However, here's how you do mathematically correct distances (note the equidistant and non
// degenerated grey isolines inside the cells) and hence edges (in yellow):
//
// https://iquilezles.org/articles/voronoilines


#define ANIMATE

float hash( float n )
{
    return fract(sin(n)*43758.5453);
}

vec2 hash( vec2 p )
{
    p = vec2( dot(p,vec2(127.1,311.7)), dot(p,vec2(269.5,183.3)) );
	return fract(sin(p)*43758.5453);
}


vec2 rotate(vec2 v, float alpha)
{
	float vx = v.x*cos(alpha)-v.y*sin(alpha);
	float vy = v.x*sin(alpha)+v.y*cos(alpha);
	v.x = vx;
	v.y = vy;
	return v;
}

float particles( in vec2 x )
{
    vec2 n = floor(x);
    vec2 f = fract(x);

    float d = 0.0;
    for( int i=0; i<=150; i++ )
	{
		vec2 particle = hash(float(i)*vec2(0.323,0.156));
		
        particle += 0.05*sin(1.0*iTime + 6.2831*particle );
		
		float w = 3.0*hash(float(i)*0.254);
		d += w/length(particle-x);
    }

    return d;
}

float sinm(float t, float vmin, float vmax)
{
	return (vmax-vmin)*0.5*sin(t)+vmin+(vmax-vmin)*0.5;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 p = gl_FragCoord.xy/iResolution.xx;

    float c = particles( p );
	float s = 0.005*c + 1.0*sin(100.0*log(c)) - 3.0*1.5;
	
    vec3 col = (0.5 + 0.5*s)*vec3(s*0.95321,s*0.35,0.25);
	
	gl_FragColor = vec4(col,1.0);
}
