#version 330
#extension GL_EXT_gpu_shader4 : enable
// Bipolar_FBM_Mod01.fsh  by   duvengar

//https://www.shadertoy.com/view/4dfBWX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform vec4      iDate;

#define iTime u_Elapsed  //*0.1666
#define iResolution u_WindowSize

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
#define RIGID_SCROLL
// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//// COLORS ////
const vec3 ORANGE = vec3(1.0, 0.6, 0.2);
 
const vec3 BLUE   = vec3(0.2, 0.6, 0.6);
const vec3 BLACK  = vec3(0.1, 0.0, 0.1);

///// MATHS /////
const float PI = 3.14;

vec2 maplinear ( in vec2 x, in vec2 a1, in vec2 a2, in vec2 b1, in vec2 b2 ) {
    return b1 + (x - a1) * (b2 - b1) / (a2 - a1);
}

///// NOISE /////
float hash( float n ) {
    return fract(sin(n)*43758.5453123);   
}

float noise( in vec2 x ){
    vec2 p = floor(x);
    vec2 f = fract(x);
    f = f * f * (3.0 - 2.0 * f);
    float n = p.x + p.y * 57.0;
    return mix(mix( hash(n + 0.0), hash(n + 1.0), f.x), mix(hash(n + 57.0), hash(n + 58.0), f.x), f.y);
}

////// FBM ////// 
mat2 m = mat2( 0.6, 0.6, -0.6, 0.8);
float fbm0(vec2 p){
 
   
    
    float f = 0.0;
    f += 0.5000 * noise(p); p *= m * 2.02;
    f += 0.2500 * noise(p); p *= m * 2.03;
    f += 0.1250 * noise(p); p *= m * 2.01;
    f += 0.0625 * noise(p); 
    f /= 0.9375;
 
    return f;
}


float fbm(vec2 p){
 
    
    int layers = 4;
    float persistance = .5;
    float strength = .5;
    float cstrength = .0;
    float n = .0;
    float offset = .01;
    float amplitude = 2.03;
    
    
    for(int i = 0; i< layers; i++){
        
    	n += strength * noise(p);
    	p *= m*amplitude;
        cstrength += strength;
        strength *= persistance;
        amplitude -= offset;
    
    }
    
     n /= cstrength;
    
    return n;
   
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    
    // pixel ratio  
	vec2 uv = gl_FragCoord.xy / iResolution.xy;  
    vec2 p = - 1. + 2. * uv;  
    p.x *= iResolution.x / iResolution.y ;
  	
    // 2 Fbm origins
    vec2  ctr  = vec2( 1.0, 0.0);
    vec2  ctr2 = vec2(-1.0, 0.0);  
    
    // MOUSE
    vec2 m = maplinear(iMouse.xy,
                       vec2(0.0),
                       vec2(iResolution.x, iResolution.y),
                       vec2(1.5, -PI),
                       vec2(7.0, 0.));
        
    // domains
    float rad  = sqrt(dot(p, p)); 
    float r    = sqrt(dot(p + ctr, p + ctr)) + m.y; 
    float r2   = sqrt(dot(p + ctr2, p + ctr2))+ m.y;  
    float a = r * r2;
                    
    // distortions      
    a *= fbm(m.x * p);
    // with symmetry
    //a *= fbm(m.x * sqrt(p*p));
    a -= iDate.w * 0.3 ;

    // colorize
    vec3 col = BLACK;
    float f = smoothstep(0.1, 0.9, fbm(vec2(a * 20.0, r * r2)));  
    col =  mix( col, BLUE, f); 
    f = smoothstep(0.4, 0.9, fbm(vec2(a * 2.0 , r * r2)));  
    col =  mix( col, ORANGE, f );
    f = smoothstep(0.3, 0.9, fbm(vec2(a * 50.0, r * r2)));  
    col *=  1.8 - f ; 

    gl_FragColor = vec4(col, 1.);
}