#version 330
#extension GL_EXT_gpu_shader4 : enable
//Mandelbrot_dwhitMod01.fsh  by   dwhit 

//https://www.shadertoy.com/view/ftcGR2
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// common //
vec2 rot(vec2 p, vec2 pivot, float angle)
{
    float s = sin(angle);
    float c = cos(angle);
    p -= pivot;
    p = vec2(p.x*c - p.y*s, p.x*s + p.y*c);
    p += pivot;
    return p;
}
//end common  //
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    
    vec2 z, zPrev;
    vec2 c = 2.4*(uv-.5) - vec2(.24,0.);
    
    float aspect = iResolution.x/iResolution.y;
    c *= vec2(aspect,1.);
    
    float r = 200.;
    float r2 = r*r;
    
    float iter;
    float maxIter = 255.;
    
    
    for(iter = 0.; iter < maxIter; iter++) {
        zPrev = rot(z, vec2(0.), iTime);
        z = vec2(z.x*z.x - z.y*z.y, 2.*z.x*z.y) + c;
        if (dot(z, zPrev) > r2){
            break;
        }
    }
    if(iter >= maxIter) {
        gl_FragColor = vec4(0);
        return;
    }
    float len = length(z);
    float fracIter = log2(log(len) / log(r));
    
    //iter -= fracIter;
    
    float m = sqrt(iter / maxIter);
    
    vec3 col = sin(vec3(.3,.45,.6)*m*20. + iTime)/2.+.5;
    
    col *= smoothstep(3., 0., fracIter);

    // Output to screen
    gl_FragColor = vec4(col,1.0);
}