#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// Frankenslug(twitch)Mod01.fsh  by  evvvvil    
//https://www.shadertoy.com/view/3dtcDB
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Frankenslug - Result of an improvised live coding session on Twitch
// LIVE SHADER CODING, SHADER SHOWDOWN STYLE, EVERY TUESDAYS 20:00 Uk time: 
// https://www.twitch.tv/evvvvil_

vec2 z,v,e=vec2(.0035,-.0035);float t,tt,g,ggg,tnoi=1.;vec3 blobP,op,po,no,al,ld,colorP;
float lngSp( vec3 p, vec3 h,float r ) {p = p - clamp( p, -h, h );return length( p )-r;}
const float PI=acos(-1.);
float smin(float a,float b,float k){float h=max(k-abs(a-b),0.);return min(a,b)-h*h*.25/k;}
float smax(float a,float b,float k){float h=max(k-abs(-a-b),0.);return max(-a,b)+h*h*.25/k;}
mat2 r2(float r){return mat2(cos(r),sin(r),-sin(r),cos(r));}
vec4 texNoise(vec2 uv){ float f = 0.; f+=texture2D(texture0, uv*.125).r*.5; f+=texture2D(texture0,uv*.25).r*.25;
                       f+=texture2D(texture0,uv*.5).r*.125; f+=texture2D(texture0,uv*1.).r*.125; f=pow(f,1.2);return vec4(f*.45+.05);}
vec2 mp( vec3 p,float s)
{
    op=blobP=p;
    vec3 hTubesP=p-vec3(0,0,0);    
    float frill=sin(p.x*30.)*.005,
        vfrill=cos(p.y*30.)*.006,
        def=sin(p.x*.5+tt)*.2+sin(p.x*.1+1.)*.3-sin(p.x*1.5)*.2+cos(p.x*p.z*.3)*.2,
        vdef=sin(p.y*.5+tt+1.),
        tunnelD=clamp(cos(p.x*.5+1.5),-.5,.5);
    hTubesP=vec3(atan(hTubesP.z,hTubesP.y)*4., length(hTubesP.zy)-6.9+tunnelD, hTubesP.x*.5);  
    float tubeD=clamp((cos(hTubesP.z*.4-.5)),-.1,.1)*5.+.5;  
    hTubesP.x=mod(hTubesP.x,6.)-3.;
    hTubesP.x=abs(hTubesP.x)-1.5;
    for(int i=0;i<3;i++){
        hTubesP.x=abs(hTubesP.x)-tubeD*.2;    
        hTubesP.x-=.15;
    }    
    blobP.xy-=def*1.5;
    vec3 blobPlugsP=vec3(abs(abs(blobP.x)-2.8)-1.4,abs(abs(abs(blobP.y)-3.5)-4.)-1.5-def*1.5,abs(blobP.z)-2.2);  
    blobPlugsP.yz*=r2(sin(p.x*.3+tt)*.1);
    blobPlugsP.z+=-.65+cos(p.y*.4)*.75;
    vec3 vertTubesP=blobPlugsP;
    vec2 h,t=vec2(.7*(length(vertTubesP.xz)-.16-vdef*.08-vfrill),7);                      //SLUG VERTICAL TUBES
    if(lngSp(blobP,vec3(7.5,0,0),5.5)<0.){
        tnoi=texNoise(p.xz*.06-vec2(.66,1.28)).r*3.8;
        t.x=min(t.x,.55*lngSp(blobP,vec3(3.9,0,0),2.5+frill+(def-tnoi)*.5));              //SLUG BODY
        t.x=smax(.8*(length(blobP-vec3(6.,.1,0))-1.1+sin(tt)*.5+tnoi*.4),t.x,.4);         //SLUG MOUTH    
        t.x=smax(.8*(length(abs(blobP.yz-vec2(3.2,0))-1.)-.12+sin(p.x*25.)*.03),t.x,1.);  //SLUG HOLE CREST
    }
    t.x=smin(.5*(length(blobPlugsP)-.6-sin(blobPlugsP.y*blobPlugsP.z*30.)*0.04),t.x,.4);  //SLUG PLUGS  
    //t.x=smax(length(blobPlugsP-vec3(0,0.4,-0.1))-.3,t.x,.5);//REMOVED TO OPTIMIZE		  //SLUG PLUG HOLES
    vec3 bubblesP=p-vec3(0,2.5+def,0);bubblesP.x=abs(abs(bubblesP.x)-2.)-1.;
    t.x=smin(t.x,max(length(bubblesP*vec3(1,sin(p.y*.5-p.x*.2-tt)*.3,1))-.3+p.y*.03,-p.y),.5); //SLUG BUBBLES  
    h=vec2(length(p.yz)-50.,5.);                                                            //TUNNNNNNNNNELLLLL  
    h.x=max(h.x,-.8*(length(p.yz)-7.+frill*2.+tunnelD));  
    vertTubesP-=vec3(0,.4,0.0);
    if(s>0.){
        float glowPlugs=.6*(length(vertTubesP)-.48);                                      //SLUG GLOW PLUGS  
        g+=0.1/(0.1*glowPlugs*glowPlugs*500.);  
        vertTubesP.xz*=r2(sin(p.y*.5)+tt);    
        vertTubesP=abs(vertTubesP)-.1-vdef*.4*clamp(p.y-2.,0.,1.)-vfrill;  
        float lazers=0.65*length(vertTubesP.xz);                                          //LAZERS
        lazers=min(lazers,glowPlugs);  
        g+=0.1/(0.1*lazers*lazers*400.);  
        h.x=min(h.x,lazers);
        float reddish=.7*lngSp(blobP-vec3(0,.75,0),vec3(4.1,0,0.),1.1+frill);             //SLUG REDISH GLOW
        ggg+=0.1/(0.1*reddish*reddish*400.);
        h.x=min(h.x,reddish);
    }
    t=t.x<h.x?t:h;    
    h=vec2(0.8*(length(hTubesP.xy)-.15+(clamp(sin(p.x*3.),-0.5,.5)+.5)*.1),6);            //TUUUUUUUUUBES WHITE
    t=t.x<h.x?t:h;    
    h=vec2(.9*length(hTubesP.xy-frill-vec2(0.3,0.))-.38-tunnelD*.2,3);                    //BLACK TUBES CASINGS
    h.x=max(h.x,-.8*(hTubesP.y+.2-frill)+sin(p.z*p.x*.05)*.2);
    h.x=max(h.x,-.9*(abs(abs(hTubesP.x-.2)-.2)-.1));  
    t=t.x<h.x?t:h;
    colorP=hTubesP;
    return t;
}
vec2 tr( vec3 ro,vec3 rd)
{
    vec2 h,t=vec2(.2);
    for(int i=0;i<128;i++){
        h=mp(ro+rd*t.x,1.);
        if(h.x<.0001||t.x>35.) break;
        t.x+=h.x;t.y=h.y;
    }
    if(t.x>35.) t.y=0.;
    return t;
}
#define a(d) clamp(mp(po+no*d,0.).x/d,0.,1.)
#define s(d) smoothstep(0.,1.,mp(po+ld*d,0.).x/d)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv=(fragCoord.xy/iResolution.xy-0.5)/vec2(iResolution.y/iResolution.x,1);
    tt=mod(iTime+9.3,62.83);
    vec3 ro=mix(vec3(18.+cos(tt*.2)*9.,4,sin(tt*.4)*4.),
                vec3(5.-sin(tt*.2)*20.,cos(tt*.2)*5.,-2.),ceil(cos(tt*0.2)));
    vec3 cw=normalize(vec3(0)-ro),cu=normalize(cross(cw,vec3(0,1,0))),
        cv=normalize(cross(cu,cw)),rd=mat3(cu,cv,cw)*normalize(vec3(uv,.5)),co,fo;
    co=fo=vec3(.2,.12,.1)-length(uv)*.1-rd.y*.2;
    ld=normalize(vec3(.3,.3,-.0));
    z=tr(ro,rd);t=z.x;
    if(z.y>0.){
        po=ro+rd*t;
        no=normalize(e.xyy*mp(po+e.xyy,0.).x+e.yyx*mp(po+e.yyx,0.).x+e.yxy*mp(po+e.yxy,0.).x+e.xxx*mp(po+e.xxx,0.).x);
        al=vec3(.6,.5,.4)-sin(colorP.x*200.)*.1;
        float spa=1.,sspa=0.;
        if(z.y<5.)al=vec3(0);
        if(z.y>5.)al=vec3(1),spa=0.;
        if(z.y>6.)al=vec3(.1,.2,.4)*.5,spa=sspa=1.;
        float dif=max(0.,dot(no,ld)),
            fr=pow(1.+dot(no,rd),4.),
            sp=pow(max(dot(reflect(-ld,no),-rd),0.),40.);
        co=mix(sp*spa+al*(a(.05)*a(.2)+.2)*(dif*vec3(.6,.7,.9)+s(.5)*sspa*2.),fo,min(fr,.5));
        co=mix(fo,co,exp(-.00008*t*t*t));
    }
    fragColor = vec4(pow(co+g*.2*vec3(.1,.3,.9)+ggg*.2*vec3(.7,.3,.2),vec3(.65)),1);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

