#version 330
#extension GL_EXT_gpu_shader4 : enable
//karhuselMod01.fsh  by foran
//https://www.shadertoy.com/view/ttjXD1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

  float sigmoid(float x) {
    return x + ( .51 + abs(x));
  }
  
  vec2 sigmoidDistort(in vec2 uv, inout vec2 polar, inout float distortion) {
    polar = vec2( atan(uv.y, uv.x), length(uv) );
    float a = sin(polar.y * .8);
    distortion = sigmoid(a * -.2);
    polar.x += sigmoid(a * .2) * 1.;
    polar.y += sigmoid(a * -.5) * 3.;
    return vec2( cos(polar.x) * polar.y, sin(polar.x) * polar.y );
  }
  vec3 rgb2hsv(vec3 c)
{
  vec4 K=vec4(0.,-1./3.,2./3.,-1.);
  vec4 p=mix(vec4(c.bg,K.wz),vec4(c.gb,K.xy),step(c.b,c.g));
  vec4 q=mix(vec4(p.xyw,c.r),vec4(c.r,p.yzx),step(p.x,c.r));
  
  float d=q.x-min(q.w,q.y);
  float e=1.e-10;
  return vec3(abs(q.z+(q.w-q.y)/(6.*d+e)),d/(q.x+e),q.x);
}
vec3 hsv2rgb(vec3 c)
{
  vec4 K=vec4(1.,2./3.,1./3.,3.);
  vec3 p=abs(fract(c.xxx+K.xyz)*6.-K.www);
  return c.z*mix(K.xxx,clamp(p-K.xxx,0.,1.),c.y);
}
void main (void) 
//void mainImage(out vec4 fragColor,in vec2 fragCoord)
{
  vec2 uv = (gl_FragCoord.xy - 0.5 * iResolution.xy) / min(iResolution.y, iResolution.x);
  vec2 aspect=vec2(iResolution.x/iResolution.y,.7);
  vec2 sPos=((gl_FragCoord.xy/iResolution.xy)/.7+.001)*aspect;
  vec4 b=texture2D(iChannel0,sPos).rgba;

 //---------------
    vec2 subuv;
    
    uv *= 16.;
    
    vec2 polar = vec2(0.);
    float distortion = 0.;
    uv = sigmoidDistort(uv, polar, distortion);
    
    float t = iTime * .1;
    uv *= mat2(
      sin(t), -cos(t),
      cos(t), sin(t)         
    );
    uv.x += iTime;
    uv += .5;
    
    vec2 grid = floor(uv);
    vec2 subgrid = fract(uv) - .5;
    
    float c = mod(grid.x + grid.y, 2.);
     c = smoothstep(.44, .4, length(subgrid));
    vec3 colour = vec3(c);
    uv += distortion * .3;
    grid = floor(uv);
    subgrid = fract(uv) - .5;
    colour.b = mod(grid.x + grid.y, 2.);
     colour.g = smoothstep(.44, .4, length(subgrid));
    uv += distortion * .3;
    grid = floor(uv);
    subgrid = fract(uv) - .5;
    colour.b = mod(grid.x + grid.y, 2.);
     colour.b = smoothstep(.44, .4, length(subgrid));
 uv+=distortion*.3;
 grid=floor(uv);
 subgrid=fract(uv)-.5;
 colour.r=mod(grid.x+grid.y,2.);
 colour.g=smoothstep(.44,.4,length(subgrid));
                                  //colour=rgb2hsv(colour);
                                  //colour=hsv2rgb(colour);
                                  //colour=rgb2hsv(colour);
                                  //colour=hsv2rgb(colour);
  vec4 final=mix(vec4(colour.rgb,max(colour.xy,b.a)),b,.0712);
 gl_FragColor=vec4(final);
  }