#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//SPACEJUNKMod01.fsh   by   greendestruction 
//https://www.shadertoy.com/view/....
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/* greetings to shadertoy friends everywhere! */
/* no textures were harmed in the making of this shader */

mat2 rot(float x) {
    return mat2(cos(x), sin(x), -sin(x), cos(x));
}

float map(vec3 p) {
	vec3 q = abs(p);
    float c = 0.9;
    float d = max(q.x, max(q.y, q.z)) - 1.0;
    d = max(d, c - max(q.y, q.z));
    d = max(d, c - max(q.x, q.z));
    d = max(d, c - max(q.x, q.y));
    return d;
}

float trace(vec3 o, vec3 r) {
    float t = 0.0;
    for (int i = 0; i < 16; ++i) {
        t += map(o + r * t);
    }
    return t;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = fragCoord.xy / iResolution.xy;
    uv = uv * 2.0 - 1.0;
    uv.x *= iResolution.x / iResolution.y;
    
    vec3 fc = vec3(0.0);
    float m = 1.0;
    
    for (int n = 0; n < 5; ++n) {
        vec3 po = vec3(0.0, 0.0, iTime * 0.5);
        vec3 pr = normalize(vec3(uv, 1.0));
        
        pr.xz *= rot(sin(iTime * 0.25) * 0.25);

        float td = 0.75 + float(n);
        
        float pt = 0.0;
        for (int i = 0; i < 16; ++i) {
            vec3 mp = po + pr * pt;
            pt += td - length(mp.xy);
        }

        vec3 pw = po + pr * pt;
        
        pw.xy /= td;

        float tc = 5.0;
        
        pw.xy *= rot(iTime * 0.125 * (mod(floor(pw.z / tc) + float(n), 2.0) * 2.0 - 1.0));
        
        pw.z = (fract(pw.z / tc) - 0.5) * tc;

        vec3 st = vec3(atan(pw.y, pw.x) / 3.141592, length(pw), 1.0);

        st.x = abs(st.x) - 0.5;
        st.y -= 0.5;

        st.xy *= 1.0 + float(n) * 0.125;

        for (int i = 0; i < 8; ++i) {
            st.xy = abs(st.xy) - 0.5;
            st.xy *= rot(3.141592 * 0.25);
            st *= 1.1;
        }

        st.xy /= st.z;

        vec3 r = normalize(vec3(st.xy, 1.0));
        vec3 o = vec3(0.0, 0.0, -4.0 - float(n));
        
        float t = trace(o, r);
        vec3 w = o + r * t;
        float fd = map(w);

        float f = 1.0 / (1.0 + pt * pt * 0.1 + fd * 100.0);
        
        float tb = 1.0 / (1.0 + t * t * 0.1);
        vec3 tex = mix(vec3(1.0, 0.25, 0.25), vec3(0.5, 1.0, 0.5), tb);
        fc += tex * f * m;
        m *= max(sign(fd - 0.1), 0.0);
    }

    fragColor = vec4(fc, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

