#version 330
#extension GL_EXT_gpu_shader4 : enable
//Kali3d2Mod01.fsh    by guil
//https://www.shadertoy.com/view/Xs2GDK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

//Based on https://www.shadertoy.com/view/4ds3zn by IQ
#define igt  iTime

vec4 ot; 
float g=1.;

vec3 C =  vec3(1.05);//vec3(.7,.9,1.41);
const int MaxIter = 12;

float zoom=1.2;

float map( vec3 p )
{
	float dr = 1.0;
	
	ot = vec4(1000.0); 
	float r2;
  
	for( int i=0; i<MaxIter;i++ )
	{
        
        
       
        r2 = dot(p,p);
        if(r2>100.)continue;
		
        ot = min( ot, vec4(abs(p),r2) );

		//Kali formula 
        p=abs(p)/r2*g-C; 
         
		dr= dr/r2*g;            
		
	}	
	return .1*(abs(p.x)+abs(p.y))*length(p)/dr;
	//return .1*(length(p.xz)*abs(p.y)+length(p.xy)*abs(p.z)+length(p.yz)*abs(p.x))/dr;
	//return .15*(length(p.xz))*length(p.xy)/dr;
	//return .125*sqrt(r2)*log(r2)/dr;
	//return .1*length(p)/dr;
	
}

float trace( in vec3 ro, in vec3 rd )
{
	float maxd = 20.;
	float precis = 0.001;
      
    float h=precis*2.0;
    float t = 0.0;
    for( int i=0; i<150; i++ )
    {
	if( t>maxd ||  h<precis*(.1+t)) continue;//break;//        
        
        t += h;
		h = map( ro+rd*t );
    }

   	if( t>maxd ) t=-1.0;
    return t;
}

vec3 calcNormal( in vec3 pos )
{
	vec3  eps = vec3(.0001,0.0,0.0);
	vec3 nor;
	nor.x = map(pos+eps.xyy) - map(pos-eps.xyy);
	nor.y = map(pos+eps.yxy) - map(pos-eps.yxy);
	nor.z = map(pos+eps.yyx) - map(pos-eps.yyx);
	return normalize(nor);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 p = -1.0 + 2.0*gl_FragCoord.xy / iResolution.xy;
    p.x *= iResolution.x/iResolution.y;

	
	vec2 m = vec2(-0.5)*6.28;
	if( iMouse.z>0.0 )m = (iMouse.xy/iResolution.xy-.5)*6.28;
	m+=.5*vec2(cos(0.15*igt),cos(0.09*igt))+.3;      
	
    // camera


	vec3 ta = vec3(0.,.2*sin(0.12*igt),0.);
	vec3 ro = ta- zoom*vec3( cos(m.x)*cos(m.y), sin(m.y), sin(m.x)*cos(m.y));
	
	
	vec3 cw = normalize(ta-ro);
	vec3 cp = vec3(0.,1.,0.0);
	vec3 cu = normalize(cross(cw,cp));
	vec3 cv = normalize(cross(cu,cw));
	vec3 rd = normalize( p.x*cu + p.y*cv + 2.0*cw );


    // trace	
	vec3 col = vec3(0.8,0.8,1.);
	float t = trace( ro, rd );
	if( t>0.0 )
	{
		
		vec3 pos = ro + t*rd;
		vec3 nor = calcNormal( pos );
		
		// lighting
        vec3  light1 = vec3(  0.577, 0.577, -0.577 );
        vec3  light2 = vec3( -0.707, -0.707,0.0  );
		float key = clamp( dot( light1, nor ), 0.0, 1.0 );
		float bac = clamp( 0.2 + 0.8*dot( light2, nor ), 0.0, 1.0 );
		float amb = (0.7+0.3*nor.y);
		float ao = pow( clamp(ot.w*2.0,0.2,1.0), 1.2 );		
        vec3 brdf = vec3(ao)*(.4*amb+key+.2*bac);

        // material		
		vec3 rgb = vec3(1.0);
		
		rgb =(0.4*abs(sin(2.5+(vec3(.5*ot.w,ot.y*ot.y,2.-5.*ot.w))))+1.6*sin(vec3(-0.2,-0.6,0.8)+0.+ot.x*18.))*.85 + .15;
		rgb.gbr=mix(rgb,rgb.bgr+vec3(0.3,0.1,-.2),0.5+.5*sin(8.5*ot.w));


		// color
		col = mix(vec3(0.8,0.8,1.),rgb*brdf,exp(-0.08*t));
	}

	
	gl_FragColor=vec4(col,1.0);
}
