#version 330
#extension GL_EXT_gpu_shader4 : enable
//izvorMod01.fsh  by 

//https://www.shadertoy.com/view/WsXfRn
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 random2( vec2 p ) {
    return fract(sin(vec2(dot(p,vec2(127.1,311.7)),dot(p,vec2(269.5,183.3))))*43758.5453);
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
    uv -= .5;
    uv.x *= iResolution.x/iResolution.y;
   
    
    
    //resize space
    uv *= 13.;
    
    vec2 st = vec2(atan(cos(uv.x*(1.-.2*cos(.6*iTime))), cos(uv.y*(1.-.2*cos(.6*iTime)))), length(uv));
    
    uv = vec2(st.x/6.2831*10. + 3.*sin(iTime), st.y*sin(.2*iTime - st.y*.1));
    
    //tile the space
    vec2 i_uv = floor(uv);
    vec2 f_uv = fract(uv);
    
    
    
    float minDist = 1.;
    
    for (int y = -1; y <= 1; y++)
    	for (int x = -1; x <= 1; x++)  
    	{
    		vec2 neighbor = vec2(float(x), float(y));
            
            
            //random position from current + neighbor place in the grid
            vec2 point = random2(i_uv + neighbor);
            
            point = .5 + .5*sin(iTime + 6.2831*point);
            
            //vector between the pixel and the point
            vec2 diff = neighbor + point - f_uv;
            
            float dist = length(diff);
            
        	minDist = min(minDist, dist);
        
         
    	}
	
    vec3 color = 1.2*minDist*vec3(.85 + .2*uv.x, .7, .65 + .1*uv.y);
    
    //draw cell center
    color += .9 * smoothstep(.09, .01, minDist);
    //color += step(.98, f_uv.x) + step(.98, f_uv.y);
    
    
    gl_FragColor = vec4(color,1.0);
}
