#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//fracdemo3Mod01.fsh by  okh0056
//https://www.shadertoy.com/view/......
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define time iTime
//-----prevoid common -----//
float sech(float ang) {
    return 1./cosh(ang);
}

vec2 sech(vec2 ang) {
    return 1./cosh(ang);
}

float csch(float ang) {
    return 1./sinh(ang);
}

vec2 csch(vec2 ang) {
    return 1./sinh(ang);
}

float coth(float ang) {
    return 1./tanh(ang);
}

vec2 coth(vec2 ang) {
    return 1./tanh(ang);
}

#define ANGLE 1.25
#define DELTA 0.00315
#define XOFF .99

float crd(float ang) {
    return 2.*sin(ang/2.);
}
vec2 crd(vec2 ang) {
    return 2.*sin(ang/2.);
}

float sec(float ang) {
    return 1./cos(ang);
}
vec2 sec(vec2 ang) {
    return 1./cos(ang);
}

float csc(float ang) {
    return 1./sin(ang);
}
vec2 csc(vec2 ang) {
    return 1./sin(ang);
}

float cot(float ang) {
    return 1./tan(ang);
}
vec2 cot(vec2 ang) {
    return 1./tan(ang);
}

//-----end prevoid common -----//

mat2 mm2(in float a){float c = cot(a), s = sin(a);return mat2(c,-s,s,c);}


float f(vec2 p, float featureSize)
{
	p.x = cos(p.x*1.3+time*0.09)*tanh(time+p.x*0.13)*2.;	
    p += csc(p.x*3.5)*0.4;
    return smoothstep(-0.01,featureSize,abs(p.y));
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) {
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{

    float aspect = iResolution.x/iResolution.y;
    float featureSize = 175./((iResolution.x*aspect+iResolution.y));

    vec2 p = fragCoord.xy / iResolution.xy*2.5;
	p.x *= aspect;
	p.y = abs(p.y);
	
	vec3 col = vec3(0);
	for(float i=2.;i<36.;i+=.33)
	{
		vec3 col2 = (cos(vec3(4.5,2.5,3.6)-i*0.45)*0.85)*(1.-f(p,featureSize));
		col = max(col,col2);
		
        p.x -= XOFF;
        p.y -= tanh(time*1.81)*3.5;
		p*= mm2(i*DELTA+ANGLE);
		
        vec2 pa = vec2(abs(p.x-0.9),abs(p.y));
        vec2 pb = vec2(p.x,abs(p.y));
        
        p = mix(pa,pb,smoothstep(-.57,.67,log2(time*3.14)-2.1));
	}
	fragColor = vec4(col,.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..

gl_FragColor.a = length(gl_FragColor.rgb)*1.0;
}
// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

