#version 330
#extension GL_EXT_gpu_shader4 : enable
//beingsMod01.fsh  by   phreax
//https://www.shadertoy.com/view/WtG3Rd
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

/* Creative Commons Licence Attribution-NonCommercial-ShareAlike 
   phreax 2020

   Elaboration of by previous experiment https://www.shadertoy.com/view/wlV3zy

   Introducing more kaleidoscopic shapes as attractor for the basic kifs pattern.
   The attractor idea goes to evvvvil - it's very interesting method to shape your kifs.
*/

#define PI 3.141592
#define TAU 2.*PI
#define hue(v) ( .6 + .6 * cos( 6.3*(v) + vec3(0,23,21) ) )
#define rot(a) mat2(cos(a), sin(a), -sin(a), cos(a))
#define COUNT 30.
#define N 10.
#define DISTORT .6
#define SQR(x) ((x)*(x))
#define SIN(x) sin(x)*.5+.5

float tt;

float flower(vec2 uv) {
    float n = 3.;
    float a = atan(uv.y,uv.x);

    float d = length( uv) - cos(a*n);
    return smoothstep(fwidth(d), -.07, abs(d));    
}


float entity(vec2 uv) {
    
	uv *= mix(.1, .7, smoothstep(0., 14., tt));       // transition effect in the beginning
  	uv = mix(fract(uv*.25-.5)-.5, uv, step(15., tt));
    
    uv *= rot(PI/2.);
    
    vec2 bp = uv;
    
    uv = abs(uv)-.2;
        
    uv *= rot(-0.5*tt);
    uv = abs(uv-.2*SIN(tt))-.2;
    uv *= rot(0.93*tt);
    
    uv += smoothstep(0., 1.5, bp.x);

    
    float r = length(uv);
    float a = atan(uv.y,uv.x);

    float f = cos(a*4.);
    
    return smoothstep(f, (f+.1), r); 
}

vec2 kalei(vec2 uv) { 
    vec2 bp = uv;

    float n = N;
    float r = TAU/n;
    
    float at = entity(uv);
    for(float i=0.; i<n; i++) {     
    	uv = abs(uv);
        uv.x -= (.2*i*at)+.2;
    	uv *= rot(r*i-.2*tt-.1*at);
    }

    uv = abs(uv) - (sin(.15*tt)+1.2);
    
    return uv;
}


vec3 spiral(vec2 uv, float i) {  
    uv *= rot(i*PI+tt*.3);
    uv += DISTORT*sin(5.*uv.yx);
	return flower(uv)*SQR(hue(i+tt*.2));
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = (gl_FragCoord.xy -.5*iResolution.xy)/iResolution.y;
    vec3 col = vec3(0);
    tt = .3*iTime;
    
    uv = kalei(uv*5.);

    float s = 1./COUNT;
	
    for(float i=0.; i<1.; i+=s) {   
        float z = fract(i-.1*tt);
        float fade = smoothstep(0., .1, 1.-abs(2.*z-1.));
        col += spiral(uv*z, i)*fade;
    }

    
    col = sqrt(col);
    gl_FragColor = vec4(col,1.);
}
