#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// wastelandMod01.fsh  by   rockhard  
//https://www.shadertoy.com/view/fldGDr
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float map(vec3 p){
    p.z+=iTime*0.5;
    //push away the height to make a road.
    float wav=(sin(p.x*0.25+4.4))*0.5
        + texture2D(texture0,p.xz*0.5).x*0.007;  
    float h = dot(sin(p - cos(p.zyx)),vec3(0.03));
    p*=0.65;
    h += dot(sin(p- cos(p.yzx*2.5)),vec3(0.05));
     //-0.35 ~ 0.52 can flatten the ground and top surface 
    return p.y + smoothstep(-0.35,0.52,h-wav);   
}

vec3 getNormal(vec3 p){
    vec2 e = vec2(0.002, -0.002); 
    return normalize(
        e.xyy * map(p + e.xyy) + e.yyx * map(p + e.yyx) + 
        e.yxy * map(p + e.yxy) + e.xxx * map(p + e.xxx));
}

vec3 col(vec3 rd, vec3 norm, float md, float t)
{     
    //a simply trick without the heavy mie calculation
    //to control color
    vec3 sun=(1.0-rd.y-rd.x)*vec3(0.4,0.3,0.2);
    vec3 sky=mix(vec3(0.25,0.2,0.1),vec3(0.0,0.3,0.75),rd.y)+sun;
    //cloud is also not nessesary this time..
    
    // light
    vec3 ld =normalize(vec3(0.25, 0.5, 0.51)); 
    
    float diff = dot(norm, ld);
    
    vec3 col= vec3(0.25)*(diff-0.5); 
    //fog
    col = mix(col,sky, 1.0 - exp(-0.0006*t*t*t) );
    //https://www.shadertoy.com/view/MlccDf
    float sand = smoothstep(-0.2, 0.35, 0.0001 / md * t);
    
    return col+sand*vec3(0.15,0.1,0.01);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = fragCoord.xy/iResolution.xy-0.5;
    float vig=(1.0-uv.x*uv.x)*(1.0-uv.y*uv.y);
    
    uv.x*=iResolution.x/iResolution.y; 
  
    vec3 ro = vec3(0.0, 0.36, 0.0); 
    vec3 rd = normalize(vec3(uv,0.65));
        
    float t = 0.1;    
    float minDist = 50.0;
    
    for (int i = 0; i < 64; i++){
        float d = map(ro + rd*t);
        if(d<0.01){
            minDist = 0.1;
            break;  
        }
        if(t>25.0) break;//early exist.               
        t += d;
    }    
    
    vec3 n =rd.y>0.15? vec3(0.0): getNormal(ro + rd * t);
    vec3 color = col(rd, n, minDist, t);
 
    fragColor = vec4(sqrt(clamp(color,0.0,1.0))*vig*1.25, 1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

