#version 330
#extension GL_EXT_gpu_shader4 : enable
// learn(3)Mod01.fsh by  saltlemon
//https://www.shadertoy.com/view/WdtyDM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

struct ray{
    vec3 o,d;
};
float N(float n){
 return fract(sin(2385.*n)*5812.);   
}
vec4 N14(float t){
 return fract(sin(t*vec4(2385.,586.,3258.,747.))*vec4(5893.,3256.,234.,5812.));   
}
ray getRay(vec2 uv,vec3 camPos,vec3 lookat,float zoom){
    ray a;
    a.o=camPos;
    vec3 f=normalize(lookat-a.o);
    vec3 r=cross(vec3(0.,1.,0.),f);
    vec3 u=cross(f,r);
    vec3 c=a.o+zoom*f;
    vec3 i=c+uv.x*r+uv.y*u;
    a.d=normalize(i-a.o);
    return a;
}
float dis(ray r,vec3 p){
     vec3 ro=r.o;
     vec3 rd=r.d;
     return length(cross(p-ro,rd))/length(rd);   
}
float Bokeh(ray r,vec3 center,float raduis,float blur)
{

    float d=dis(r,center);
    raduis *=length(center);
    float sphere=smoothstep(raduis,raduis*(1.-blur),d);
    sphere*=mix(.6,1.,smoothstep(raduis*.8,raduis,d));
    return sphere;
}
vec3 strightLight(ray r,float t,vec3 color){
    float side=step(r.d.x,0.);
    r.d.x=abs(r.d.x);
    
    float d=0.;
    for(float i=0.;i<1.;i+=.1){
        float ti=fract(t+i+side*0.05);
        d+=Bokeh(r,vec3(2.,2.,100.-100.*ti),.05,.1)*ti*ti*ti;
    }
    vec3 col=d*color;
    return col;
}
vec3 headLight(ray r,float t,vec3 color){
    t*=2.;
    float w1=.25;
    float w2=w1*1.2;
    float d=0.;
    float s=1./30.;
    for(float i=0.;i<1.;i+=s){
        if(N(i)>.1)continue;
        float ti=fract(t+i);
        float z= 100.-ti*100.;
        float fade=ti*ti*ti*ti*ti;
        float focus=smoothstep(.9,1.,ti);
        
        float size=mix(.05,.03,focus);
        d+=Bokeh(r,vec3(-1.-w1,.15,z),size,.1)*fade;
        d+=Bokeh(r,vec3(-1.+w1,.15,z),size,.1)*fade;
        d+=Bokeh(r,vec3(-1.-w2,.15,z),size,.1)*fade;
        d+=Bokeh(r,vec3(-1.+w2,.15,z),size,.1)*fade;
        float ref=0.;
        ref+=Bokeh(r,vec3(-1.-w2,-.15,z),size*3.,1.)*fade;
        ref+=Bokeh(r,vec3(-1.+w2,-.15,z),size*3.,1.)*fade;
       
        d+=ref*focus;
        
        
    }
    vec3 col=d*color;
    return col;
}
vec3 tailLight(ray r,float t,vec3 color){
    t*=.25;
    float w1=.25;
    float w2=w1*1.2;
    float d=0.;
    float s=1./15.;
    for(float i=0.;i<1.;i+=s){
        float n=N(i);
        if(n>.5)continue;
        float lane=step(0.25,n);
        float ti=fract(t+i);
        float z= 100.-ti*100.;
        float fade=ti*ti*ti*ti*ti;
        float focus=smoothstep(.9,1.,ti);
        
        float laneshift=smoothstep(1.,.96,ti);
        float blink=step(0.,sin(t*1000.))*7.*lane*step(.96,ti);
        float size=mix(.05,.03,focus);
        float x=1.5-lane*laneshift;
        d+=Bokeh(r,vec3(x-w1,.15,z),size,.1)*fade;
        d+=Bokeh(r,vec3(x+w1,.15,z),size,.1)*fade;
        d+=Bokeh(r,vec3(x-w2,.15,z),size,.1)*fade;
        d+=Bokeh(r,vec3(x+w2,.15,z),size,.1)*fade*(1.+blink);
        float ref=0.;
        ref+=Bokeh(r,vec3(x-w2,-.15,z),size*3.,1.)*fade;
        ref+=Bokeh(r,vec3(x+w2,-.15,z),size*3.,1.)*fade*(1.+blink*.1);
       
        d+=ref*focus;
        
        
    }
    vec3 col=d*color;
    return col;
}
vec3 envLight(ray r,float t,vec3 color){
    float side=step(r.d.x,0.);
    r.d.x=abs(r.d.x);
    
    vec3 col=vec3(0.);
    for(float i=0.;i<1.;i+=.1){
        float ti=fract(t+i+side*0.05);
        
        vec4 n=N14(i+side*123.);
        float x=mix(2.5,10.,n.x);
        float y=mix(.1,1.5,n.y);
        float fade=sin(ti*3.14*20.*n.x)*0.5+0.5;
        vec3 p=vec3(x,y,50.-50.*ti);
        col+=Bokeh(r,p,.05,.1)*fade*n.wzy*.5;
    }

    return col;
}
vec2 rain(vec2 uv,float t){
    t*=40.;
    
    
    
    vec2 a=vec2(3.,1.);
    vec2 suv=uv*a;
    
    vec2 id = floor(suv);
    suv.y+=t*.22;
    float n=fract(sin(id.x*123.98)*965.25);
    suv.y+=n;
    uv.y+=n;
    vec2 st=fract(suv)-.5;
    
    id = floor(suv);
    t+=fract(sin(id.x*155.48+id.y*215.32)*9695.25)*7.576;
    float y=-sin(t+sin(t+sin(t)*.5))*.43;
    vec2 p1=vec2(0.,y);
    vec2 o1=(st-p1)/a;
    float d=length(o1);
    float m1=smoothstep(.07,.0,d);
   
    vec2 o2=(fract(uv*a.x*vec2(1.,2.))-.5)/vec2(1.,2.);
    d=length(o2);
    float m2=smoothstep(.3*(.5-st.y),.0,d)*smoothstep(-.1,.1,st.y-p1.y);
    //if(st.x>.46||st.y>.49) m1=1.;
    return vec2(m1*o1*30.+m2*o2*10.);   
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
	uv-=.5;
    uv.x*=iResolution.x/iResolution.y;
    // Time varying pixel color
   
    vec2 m=iMouse.xy/iResolution.xy;
    float t=iTime*.05+m.x;
   	vec3 camPos=vec3(0.5,.2,0.);
    vec3 lookat=vec3(0.5,.2,1.);
    vec2 rainDistort=rain(uv*5.,t)*.5;
    rainDistort+=rain(uv*7.,t)*.5;
    uv.x+=sin(uv.y*70.)*0.002;
    uv.y+=sin(uv.x*170.)*0.0015;
    ray r=getRay(uv-rainDistort*.5,camPos,lookat,2.);
    
    vec3 col=strightLight(r,t,vec3(1.,.7,.3));
    col+=headLight(r,t,vec3(.9,.9,1.));
    col+=tailLight(r,t,vec3(1.,.1,.03));
    col+=envLight(r,t,vec3(0.,0.,0.));
    col+=(r.d.y+.25)*vec3(.2,.1,.5);
    
    //col=vec3(rainDistort,0.);
    gl_FragColor = vec4(col,1.);
}