#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//KnottingMod01.fsh   by   shezard  
//https://www.shadertoy.com/view/lt23WK
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14
#define TAU 6.28318530718

vec3 rgb2hsv(vec3 c) {
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = mix(vec4(c.bg, K.wz), vec4(c.gb, K.xy), step(c.b, c.g));
    vec4 q = mix(vec4(p.xyw, c.r), vec4(c.r, p.yzx), step(p.x, c.r));

    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c) {
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

float noise(in vec2 uv) {
	return sin(1.5*uv.x)*sin(1.5*uv.y);
}

const mat2 m = mat2( 0.80,  0.60, -0.60,  0.80 );

float fbm(vec2 uv) {
    float f = 0.0;
    f += 0.5000*noise(uv); uv = m*uv*2.02;
    f += 0.2500*noise(uv); uv = m*uv*2.03;
    f += 0.1250*noise(uv); uv = m*uv*2.01;
    f += 0.0625*noise(uv);
    return f/0.9375;
}

float fbm2(in vec2 uv) {
   vec2 p = vec2(fbm(uv + vec2(0.0,0.0)),
                 fbm(uv + vec2(5.2,1.3)));

   return fbm(uv + 4.0*p);
}

float rand(in vec2 uv) {
    return fract(sin(dot(uv.xy ,vec2(12.9898,78.233))) * 43758.5453);
}

vec2 add(in vec2 a, in vec2 b) {
 
    float mat;
    if(a.x < b.x) {
      mat = a.y;
    } else {
      mat = b.y;
    }
    
    return vec2(min(a.x,b.x), mat);
}

vec2 sub(in vec2 a, in vec2 b) {
    
    float mat;
    if(a.x < b.x) {
      mat = b.y;
    } else {
      mat = a.y;
    }
    
    return vec2(max(a.x, b.x), mat);
}

vec3 rep(in vec3 p, in vec3 c) {
    vec3 q = mod(p,c)-0.5*c;
    return q;
}

vec2 rotate(in vec2 p, in float ang) {
    float c = cos(ang), s = sin(ang);
    return vec2(p.x*c - p.y*s, p.x*s + p.y*c);
}

vec2 torus(in vec3 p, in vec2 t, in float mat) {
  vec2 q = vec2(length(p.xz)-t.x,p.y);
  return vec2(length(q)-t.y, mat);
}

vec2 sphere(in vec3 p, in float r, in float mat) {
    return vec2(length(p) - r, mat);
}

vec2 plane(in vec3 p, in vec4 n, in float mat) {
  return vec2(dot(p,n.xyz) + n.w, mat);
}

vec2 cylinder(in vec3 p, in vec3 c, in float mat) {
  return vec2(length(p.xz-c.xy)-c.z, mat);
}

vec2 box(in vec3 p, in vec3 b, in float mat) {
  return vec2(length(max(abs(p)-b,0.0)), mat);
}

// WIP
float trans(in float x, in vec2 p) {
   return mod(x, 0.001*TAU) - 0.001*TAU / 2.0;
}


vec2 knot(in vec3 p, in float k, in float mat) {
    float r = length(p.xy);
    float oa, a = atan(p.y, p.x); 
    oa = k*a;
    a = trans(a, p.xy);
    
    p.xy = r*vec2(cos(a), sin(a)); p.x -= 6.0;
    p.xz = cos(oa)*p.xz + sin(oa)*vec2(-p.z, p.x);
    p.x = abs(p.x) - 1.35; 
    return vec2(length(p) - 1.0, mat);
}

float map(in vec3 p, inout float mat) {
   
   p.z = cos(p.z);
    
   vec2 scene = vec2(999.0, 0.0);
   
    // TODO : see how to interpolate between rate N and N+1
   float rate = 1.0; // mod(iTime, 3.0);
   
   float r1 = floor(rate);
   float r2  = floor(rate) + 1.0;
    
   vec2 k = knot(p, r1, length(p+fbm2(p.xy))*.1);
    
   vec2 k2 = knot(p, r2, length(p+fbm2(p.xy))*.1);
    
   float y = 0.5 + cos(iTime) * 0.5;
    
   scene = add(scene,mix(k,k2,y));
    
   mat = scene.y;
   return scene.x;
}

mat3 setLookAt(in vec3 ro, in vec3 ta,in float cr) {
	vec3  cw = normalize(ta-ro);
	vec3  cp = vec3(sin(cr), cos(cr),0.0);
	vec3  cu = normalize( cross(cw,cp) );
	vec3  cv = normalize( cross(cu,cw) );
    return mat3( cu, cv, cw );
}

float softshadow(in vec3 ro, in vec3 rd, in float mint, in float tmax) {
	float res = 1.0;
    float t = mint;
    
    float mat = 0.0;
    
    for( int i = 0; i < 16; i++ ) {
		float h = map(ro + rd*t, mat);
        res = min( res, 4.0*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( h<0.001 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec2 uv = fragCoord.xy / iResolution.xy;
    vec2 p = -1.0 + 2.0*uv;
    p.x *= iResolution.x / iResolution.y;
    
    // camera	
    vec3 ro = vec3(
        0.0,
        0.0,
        16.0+iTime*5.0
   	);
    vec3 ta = vec3(0.0,0.0,0.0);
    float roll = iTime*.1;

    // camera tx
    mat3 ca = setLookAt( ro, ta, roll );
    vec3 rd = normalize( ca * vec3(p.xy,1.75) );

    float t = 0.001;      // Near
    float tmax = 120.0; // Far
   	
    float h = 0.001;
    float hmax = 0.001;
    
    float mat = 0.0;
    
    vec3 c = vec3(0.0);
    vec3 ao = vec3(0.0);
    
    const int steps = 100;
    for(int i = 0 ; i < steps ; i++) {
        
        if(h < hmax || t > tmax ) {
        	ao = vec3(1.0) - float(i)/float(steps);
            break;
        }
        
        h = map(ro + t *rd, mat);
        t += h;
    }
    
    if(t < tmax) {
        vec3 pos = ro+rd*t;
        
        vec2 r = vec2(0.001,0.0);
        vec3 nor = normalize(vec3(map(pos+r.xyy, mat)-map(pos-r.xyy, mat),
                                  map(pos+r.yxy, mat)-map(pos-r.yxy, mat),
                                  map(pos+r.yyx, mat)-map(pos-r.yyx, mat)));
      	vec3 ref = reflect(rd,nor);
        
        c = vec3(1.0,1.2,1.1);;
        
        if(mat == 0.0) {
            c = vec3(0.0);
        } else {
            c = vec3(.5,.1,.3);
            
            c = rgb2hsv(c);
            
            c.x += mat+.1 + pos.z*.1;
            c.y = .85;
            c.z = 1.4;
            
            c = hsv2rgb(c);
        }
        
        float power = 8.0;
        ao = vec3(pow(ao.x,power),pow(ao.y,power),pow(ao.z,power));
        
        c *= 1.0 - exp(1.0 / log(ao));
    } else {
        c = vec3(0.);
    }
    
	fragColor = vec4(c,1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

