#version 330
#extension GL_EXT_gpu_shader4 : enable
//FractasticMod01.fsh by  thebeardphantom
//https://www.shadertoy.com/view/XdSfzc
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float _Scale = 1.0;
float _Iterations = 500.0;
vec2 _Seed = vec2(0.14, 0.6316);
float _AnimSpeed = 0.125;
vec2 _Anim = vec2(0.01, 0.01);
float _Stepping = 200.0;
float _AnimT;


float Fractal(vec2 coord)
{    
    vec2 z;
    z.x = 3.0 * (coord.x - 0.5) * _Scale;
    z.y = 2.0 * (coord.y - 0.5) * _Scale;

    float i;
    for (i = 0.0; i < _Iterations; i++)
    {
        float x = (z.x * z.x - z.y * z.y) + (_Seed.x +  _AnimT * _Anim.x);
        float y = (z.y * z.x + z.x * z.y) + (_Seed.y +  _AnimT * _Anim.y);

        if ((x * x + y * y) > 4.0) break;
        z.x = x;
        z.y = y;
    }
    return i;
}
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    _AnimT = (cos(iTime * _AnimSpeed) + 1.0) / 2.0;
    // Zoom in and out
    _Scale = mix(0.3, 0.0125, _AnimT);
    // Affects the banding colors
	_Stepping = mix(100.0, 1000.0, 1.0 - _AnimT * 4.0);
    // Calculate iteration at which the value is inside the set
    float f = Fractal(gl_FragCoord.xy / iResolution.xy);
    gl_FragColor = texture2D(iChannel0, vec2((f == _Iterations ? 0.0 : f) / _Stepping, 0.0));
}