#version 330
#extension GL_EXT_gpu_shader4 : enable
//WetshaderMod01.fsh  by   totetmatt
 
//https://www.shadertoy.com/view/wddcDN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 z,v,e=vec2(.001,-.001); 


mat2 r(float a){
    float c=cos(a),s=sin(a);
    return mat2(c,s,-s,c);
}
void md(inout vec2 uv,vec2 p){
    uv = abs(uv) - p;
    if(uv.x < uv.y) uv.xy = uv.yx;
}
vec2 pModMirror2(inout vec2 p, vec2 size) {
    vec2 halfsize = size*0.5;
    vec2 c = floor((p + halfsize)/size);
    p = mod(p + halfsize, size) - halfsize;
    p *= mod(c,vec2(2.))*2. - vec2(1.);
    return c;
}
float pMod1(inout float p, float size) {
    float halfsize = size*0.5;
    float c = floor((p + halfsize)/size);
    p = mod(p + halfsize, size) - halfsize;
    return c;
}
vec2 sdf(vec3 p){

       p.z   -=(iTime);
       p.xy  *=r(iTime*.2);
       float c= pMod1(p.z,12.);
       p.xy  *=r(c*.5);
    p.x = abs(p.x)-12.5;
    p.y = abs(p.y)-4.5;
      p.xy  *=r(iTime*.5);
     vec2 h,t=vec2(length(p)-2.,4.);

   
        p.x = abs(p.x)-1.3;
        p.y -=1.8;
     h = vec2(length(p)-1.,5.);
     t = t.x< h.x ? t : h; 
     t.x*=.7;

 
    return t;

}
#define TRLIMIT 256.
vec2 tr(vec3 ro, vec3 rd){
    vec2 h,t=vec2(.1);
    for(float i=0.;i<TRLIMIT;i++){
        h= sdf(ro+rd*t.x);
        if(h.x < .0001 || t.x > TRLIMIT) break;
        t.x+=h.x;
        t.y=h.y;
    }
    if(t.x>TRLIMIT) t.y=0.;
    return t;
    
}

#define a(d) clamp(sdf(po+no*d).x/d,0.,1.)
#define s(d) smoothstep(0.,1.,sdf(po+ld*d).x/d)
void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord)
{
    vec4 cam = vec4(sin(iTime*.5)*.5,cos(iTime*1.),10.0,1.50);
    vec2 uv = (gl_FragCoord.xy -.5* iResolution.xy)/iResolution.y;
    vec3 ro = vec3(cos(cam.w+cam.x)*cam.z, cam.y,sin(cam.w+cam.x)*cam.z);
   
    vec3 cw = normalize(vec3(0.)-ro);
    vec3 cu = normalize(cross(cw,vec3(0.,1.,0.)));
    vec3 cv = normalize(cross(cu,cw));
    vec3 rd = mat3(cu,cv,cw)*normalize(vec3(uv,.5));
    
    vec3 co, fo = vec3(.0)-length(uv)*.1-rd.y*.1;
    co = fo;
    vec3 ld = normalize(vec3(1.2,1.3,10.5));
    
    vec2 z = tr(ro,rd);
    float t = z.x;
    vec3 al ;
    if(z.y > 0.) { 
        vec3 po  = ro+rd*t;
        vec3 no = normalize(e.xyy*sdf(po+e.xyy).x +
        e.yyx*sdf(po+e.yyx).x +
        e.yxy*sdf(po+e.yxy).x +
        e.xxx*sdf(po+e.xxx).x );
        if(z.y ==3.){
        al = vec3(1.0,1.0,1.0);
        }
        if (z.y == 4.) {
            al=vec3(1.0,.0,.0);
        }
        if(z.y == 5.) {
         al = vec3(1.0,1.0,1.0);
        }
        float dif = max(0.,dot(no,ld)),
        fr = pow(1.+dot(no,rd),4.), //Fersnel
        sp = pow(max(dot( reflect(-ld,no),-rd),0.),40.); //specular
        co = mix(sp+al*(a(.05)*a(.1)+.2)*(dif+s(2.)),fo,min(fr,.5));
    }
    
    gl_FragColor = vec4(pow(co,vec3(.945)),1.0);
}