#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//7_100Mod01.fsh   by   yahe
//https://www.shadertoy.com/view/4dffzN
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float noise(in vec2 position) {
    return fract(sin(dot(position.xy,
                         vec2(12.9898,78.233)))*
        43758.5453123);
}

// Value Noise courtesy of Book of Shaders
// https://thebookofshaders.com/11/
float noise2d(vec2 uv) {
    
    vec2 pos = floor(uv);
    vec2 fractional = fract(uv);
    
    // four corners
    float a = noise(pos);					// bottom left
    float b = noise(pos + vec2(1., 0.));	// bottom right
    float c = noise(pos + vec2(1., 1.));	// top right
    float d = noise(pos + vec2(0., 1.));	// top left
    
    vec2 intermix = smoothstep(0., 1., fractional);
    
    float value = mix(a, b, intermix.x);
    value += (d - a) * intermix.y * (1.0 - intermix.x);
    value += (c - b) * intermix.x * intermix.y;
    
    return value;
}

// Fractal noise courtesy of iq
// https://www.shadertoy.com/view/XdXGW8
float fractalNoise2d(vec2 uv) {
    uv *= 3.0;
    uv.x -= iTime / 5.0;
    uv.y += sin(iTime / 5.0) * 2.0;
    
    mat2 rotate = mat2(1.6 - sin(iTime / 100.0) / 10.0, 1.2, -1.2, 1.6);
    
    float value = 0.5 * noise2d(uv);
    uv *= rotate;
    value += 0.25 * noise2d(uv);
    uv *= rotate;
    value += 0.125 * noise2d(uv);
    uv *= rotate;
    value += 0.0625 * noise2d(uv);
    
    return value;
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
	vec2 uv = fragCoord.xy / iResolution.xy;
    uv -= 0.5;
    uv.y *= iResolution.y/iResolution.x;
    
    // use josemorval paper sheet for reference
    float dist,dist1,mask,l,final = 1.0;
	//This parameter controls how many sheets are in the picture
    float s = 0.01;
	
    float amp,freq;
	uv.y -=iResolution.y/iResolution.x;
    
    float value = fractalNoise2d(uv)*5.;
    
    //This parameter controls when the algorithm stop drawing sheets (-1 is no sheet, 1 all sheets)
    float factorSheets = iResolution.y/iResolution.x;
    
    for(float f = -iResolution.y/iResolution.x; f < factorSheets; f+=s){
        uv.y += s;
        //This parameter controls the frequency of the waves, modulated by an exp along the x-axis 
        freq = 5.0*exp(-10.0*(f*f)) + value*sin(iTime);
        //This parameter controls the amplitude of the waves, modulated by an exp along the x-axis 
        amp = 0.12*exp(-10.0*(f*f)) + value / 20. *cos(iTime);
        dist = amp*pow(sin(freq*uv.x + iTime + 100.0),2.0)*exp(-5.0*uv.x*uv.x)-uv.y;
        mask = 1.0-smoothstep(0.0,0.005,dist);

        //Draw each line of the sheet
        dist1 = abs(dist);
        dist1 = smoothstep(0.0,0.01,dist1);
		
        final = mix(dist1, -dist1*final,mask);
	}

	fragColor = vec4(final*2.,final,final*uv.y*3., 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

