#version 120

uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 vTexCoord = gl_TexCoord[0];
uniform vec2 textureSize0;
uniform vec2 textureSize1;
uniform vec2 textureSize2;
uniform vec2 textureSize3;
uniform float u_Elapsed;
vec2 Offset0 = vec2(1.0) / textureSize0;
vec2 Offset1 = vec2(1.0) / textureSize1;
vec2 Offset2 = vec2(1.0) / textureSize2;
vec2 Offset3 = vec2(1.0) / textureSize3;
vec3 outp;
vec3 LC = vec3(0.2126, 0.7152, 0.0722);//correct


float GetLuma(vec3 rgb) {
    return dot(LC, rgb);
}

vec4 BG = texture2D(texture1, vTexCoord.xy);

void main(void)
{

vec4 Girl1 = texture2D(texture0, vTexCoord.xy);
vec4 Girl2 = texture2D(texture0, vTexCoord.xy + Offset1 * vec2 ( 0.0, 1.0) );
vec4 Girl3 = texture2D(texture0, vTexCoord.xy + Offset1 * vec2 ( 1.0, 0.0) );
vec4 Girl4 = texture2D(texture0, vTexCoord.xy + Offset1 * vec2 ( 0.0,-1.0) );
vec4 Girl5 = texture2D(texture0, vTexCoord.xy + Offset1 * vec2 (-1.0, 0.0) );

vec4 Girl2a = texture2D(texture2, vTexCoord.xy + Offset2 * vec2 ( 0.0, 2.0) );
vec4 Girl3a = texture2D(texture2, vTexCoord.xy + Offset2 * vec2 ( 2.0, 0.0) );
vec4 Girl4a = texture2D(texture2, vTexCoord.xy + Offset2 * vec2 ( 0.0,-2.0) );
vec4 Girl5a = texture2D(texture2, vTexCoord.xy + Offset2 * vec2 (-2.0, 0.0) );

vec4 Girl2b = texture2D(texture3, vTexCoord.xy + Offset3 * vec2 ( 0.0, 4.0) );
vec4 Girl3b = texture2D(texture3, vTexCoord.xy + Offset3 * vec2 ( 4.0, 0.0) );
vec4 Girl4b = texture2D(texture3, vTexCoord.xy + Offset3 * vec2 ( 0.0,-4.0) );
vec4 Girl5b = texture2D(texture3, vTexCoord.xy + Offset3 * vec2 (-4.0, 0.0) );

float G1 = GetLuma(Girl1.rgb);
float G2 = GetLuma(Girl2.rgb);
float G3 = GetLuma(Girl3.rgb);
float G4 = GetLuma(Girl4.rgb);
float G5 = GetLuma(Girl5.rgb);

float G2a = GetLuma(Girl2a.rgb);
float G3a = GetLuma(Girl3a.rgb);
float G4a = GetLuma(Girl4a.rgb);
float G5a = GetLuma(Girl5a.rgb);

float G2b = GetLuma(Girl2b.rgb);
float G3b = GetLuma(Girl3b.rgb);
float G4b = GetLuma(Girl4b.rgb);
float G5b = GetLuma(Girl5b.rgb);


vec2 l1;
l1.g = ( (G1-G2)+(G4-G1) );
l1.r = ( (G1-G3)+(G5-G1) );
vec2 l2;
l2.g = ( (G1-((G2+G2a) ))+(((G4+G4a) )-G1) );
l2.r = ( (G1-((G3+G3a) ))+(((G5+G5a) )-G1) );
vec2 l3;
l3.g = ( (G1-((G2+G2a+G2b) ))+(((G4+G4a+G4b) )-G1) );
l3.r = ( (G1-((G3+G3a+G3b) ))+(((G5+G5a+G5b) )-G1) );

vec3 col;
col.b = GetLuma(Girl1.rgb);
col.rg = (l1+l2+l3);
col.g = -col.g;


float mul1 = 530.0*BG.r;
float mul2 = 540.0*BG.g;
float mul3 = 550.0*BG.b;



outp.r = texture2D(texture1, vTexCoord.xy + Offset1 * vec2 ( col.r*mul1, col.g*mul1) ).r;
outp.g = texture2D(texture1, vTexCoord.xy + Offset1 * vec2 ( col.r*mul2, col.g*mul2) ).g;
outp.b = texture2D(texture1, vTexCoord.xy + Offset1 * vec2 ( col.r*mul3, col.g*mul3) ).b;


outp.rgb = mix(Girl1.rgb, outp.rgb,  smoothstep(0.50, 0.51, col.b+(sin(u_Elapsed*0.5))  ) );

gl_FragColor = vec4( outp.rgb, Girl1.a);


}
