#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//magnets_3vizMod01.fsh   by   zithral  
//https://www.shadertoy.com/view/sd3fWS
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract



float Sigmoid (float x) {
    return 2.0 / (1.0 + exp(-x)) - 1.0; 
}

vec3 hue2rgb(float h){
    vec3 rgb = clamp(abs(mod(h*6.0+vec3(0.0,4.0,2.0),
                             6.0)-3.0)-1.0,
                     0.0,
                     1.0 );
    rgb = rgb*rgb*(3.0-2.0*rgb);
    return rgb;
}



//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    float tau = 2.*3.141;
    
    const int num = 4;
    vec2[num] ps = vec2[](
        vec2(.3, .7),
        vec2(.7, .3),
        vec2(.5, .8),
        vec2(.4, .6)
    );
    float[num] cs = float[](+1., +1., -1., -1.);

    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = fragCoord;
    float t = 0.1 * iTime;
    
    vec3 col = vec3(0.);
    float sum = 0.;
    vec2 forces = vec2(0.);
    for (int i = 0; i < num; i++) {
        vec2 p = ps[i] * iResolution.xy;
        float rand = fract(sin(1000.*float(i+1)));
        vec2 offs = 0.2*iResolution.x*(1.1-rand)*vec2(cos(tau*t*rand), sin(tau*t*rand));
        p += offs;
        
        
        float c = cs[i];
        
        vec2 dir = p - uv;
        float d = length(dir);
        
        if (d < 10.) {
            if (c == +1.) {
                col = vec3(1., 0.5, 0.);
            } else {
                col = vec3(0., 0.5, 1.);
            }
        }
        
        float f = 1./(d*d);
        
        sum += c * f;
        forces += c * f * dir;
    }
    
    
    forces /= length(forces);
    float ang = atan(forces.y, forces.x) / tau;
    if (col == vec3(0)) {
        col = vec3(0.1);
        col = 0.5*hue2rgb(ang);
        
        float rad = 25.;
        float size = 2.1*rad;
        vec2 compass = round(uv/size) * size;
        vec2 dir1 = compass - uv;
        vec2 dir2 = -dir1;
        float len = length(dir1);
        if (len < rad) {
            col = vec3(0.2);
            len /= rad;
            dir1 /= length(dir1);
            dir2 /= length(dir2);
            
            if (length(forces-dir1) < 0.5*(1.-len)) {
                col = vec3(0., 0.5, 1.);
            }
            if (length(forces-dir2) < 0.5*(1.-len)) {
                col = vec3(1., 0.5, 0.);
            }
        }
    }
    
    
    
    
    
    if (col != vec3(0)) {
        sum = Sigmoid(50000.*sum);
        float val = abs(sum);
        
        val = floor(fract(8.*(abs(sum)-.01))+.05);
        
        //float val = min(1., 1. - 1./(abs(sum)));
        if (0.1 < val) {
            if (sum > 0.) {
                col = vec3(val, 0., 0.);
            } else {
                col = vec3(0., val, val);
            }
        }
    }
    
    
    
    // Output to screen
    fragColor = vec4(col, 1.0);

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

