#version 140
#extension GL_EXT_gpu_shader4 : enable
//JormalatohotysMod01.fsh by Apaksi
//https://www.shadertoy.com/view/3sVBWG
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float angle = iTime * 0.4;
    vec2 o = vec2(500.0 * cos(iTime * 0.1 + gl_FragCoord.xy/200.0),
                  500.0 * sin(iTime * 0.11 +     gl_FragCoord.xy/200.0+gl_FragCoord.xy/300.0));
    gl_FragCoord.xy -= o;
    mat2 rot = mat2(vec2(cos(angle), sin(angle)),
                    vec2(-sin(angle), cos(angle)));
    gl_FragCoord = rot * gl_FragCoord.xy;
    gl_FragCoord += o;
    
    vec3 c = vec3(0.1, 0.0, 0.0);

    vec2 uv = gl_FragCoord.xy / iResolution.xy;
    uv -= vec2(0.5, 0.5) * sin(iTime * 0.3);
    
    float size = 80.0 + 200.0 * (0.5 + 0.5 * sin(iTime * 0.535 + uv.x * uv.y));
    float a = (mod(gl_FragCoord.y, 2.0*size) - size) / size;
    float b = (mod(gl_FragCoord.x, 2.0*size) - size) / size;

    if (a < 0.0) {
        c = mix(vec3(0.0, 0.0, 0.2), vec3(0.5, 0.5, 1.6), pow(abs(b), 2.0));
    } else {
        c = mix(vec3(0.2, 0.0, 0.0) , vec3(1.6, 0.6, 0.6), pow(abs(b), 4.0));
    }

    gl_FragColor = vec4(c, 1.0);
}
