//#version 140
//#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//GridBlend7Mod01.fsh   by  Del
//https://www.shadertoy.com/view/fdf3zs
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


vec4 HexGrid(vec2 uv, out vec2 id)
{
    uv *= mat2(1.1547,0.0,-0.5773503,1.0);
    vec2 f = fract(uv);
    float triid = 1.0;
    if((f.x+f.y) > 1.0)
    {
        f = 1.0 - f;
     	triid = -1.0;
    }
    vec2 co = step(f.yx,f) * step(1.0-f.x-f.y,max(f.x,f.y));
    id = floor(uv) + (triid < 0.0 ? 1.0 - co : co);
    co = (f - co) * triid * mat2(0.866026,0.0,0.5,1.0);
    uv = abs(co);
    id*=inverse(mat2(1.1547,0.0,-0.5773503,1.0));
    return vec4(0.5-max(uv.y,abs(dot(vec2(0.866026,0.5),uv))),length(co),co);
}
vec4 TriGrid(vec2 uv, out vec2 id)
{
    float scaler = 0.866026;
    uv *= mat2(1,-1./1.73, 0,2./1.73)*scaler;
    vec3 g = vec3(uv,1.-uv.x-uv.y);
    vec3 _id = floor(g)+0.5;
    g = fract(g);
    float lg = length(g);
    if (lg>1.)
        g = 1.-g;
    vec3 g2 = abs(2.*fract(g)-1.);
    vec2 triuv = (g.xy-ceil(1.-g.z)/3.) * mat2(1,.5, 0,1.73/2.);
    float edge = max(max(g2.x,g2.y),g2.z);
    id = _id.xy;
    id*= mat2(1,.5, 0,1.73/2.);
    id.xy += sign(lg-1.)*0.1;
    return vec4(((1.0-edge)*0.43)/scaler,length(triuv),triuv);
}
float hbar(vec2 p, float nline, float t)
{
return 0.5+sin((p.y*nline)+t)*0.5;
}
float smin( float a, float b, float k )
{
float h = clamp( 0.5 + 0.5*(b-a)/k, 0.0, 1.0 );
return mix( b, a, h ) - k*h*(1.0-h);
}
mat2 _rot(float th)
{
	vec2 a = sin(vec2(1.5707963, 0) + th);
	return mat2(a.xy, -a.y, a.x);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float tt = iTime;
    vec2 uv = (fragCoord.xy - 0.5 * iResolution.xy) / iResolution.y;
    uv *= _rot(iTime*0.1);
    vec2 id;
    vec2 id2;
    float zoom = 5.;
    zoom += sin(uv.x*2.0+tt) * 0.5;
    vec4 h = HexGrid(uv*zoom*2.0, id)*1.1;
    uv *= _rot(-iTime*0.16);
    vec4 h2 = TriGrid(uv*zoom, id2)*1.1;
    h.x = min(h.x+1.5, h2.x*2.75);
    float vvv1 = abs(h2.x-h.x)*0.4;
    float vvv2 = abs(h2.y-h.y)*0.25;
	h.x = smin(h.x,h2.y-0.05,1.95);
    id = mix(id,id2,0.5);
    float vvv = min(vvv1,vvv2)*(1.75+sin(tt*1.5+length(id*16.0)));
    vec3 shapecol = vec3(0.125, 0.275, 0.155)*.95;
	shapecol = shapecol.xzy;
    vec3 shapecol2 = vec3(1.53,0.9,0.7) * 5.0;
    shapecol = mix(shapecol,shapecol2,vvv);
    float cm = 1.0 + pow(abs(sin(length(id)*.25 + tt*0.65)), 32.0);
    cm *= 1.0 + (hbar(h.zw,100.0,tt*12.0)*0.1);
    shapecol *= cm;
    vec3 bordercol = shapecol;
    vec3 finalcol = mix(bordercol*0.2,shapecol,smoothstep(-0.05, 0.045, h.x));
    fragColor = vec4(finalcol*3.2,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

