#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//LeafyWibbleMod01.fsh  by  Del 
//https://www.shadertoy.com/view/3dcyDj
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// A Green Leafy thing :)

float wave(vec2 p)
{
  float v = sin(p.x + sin(p.y) + sin(p.y * .43));
  return v*v;
}
 
float get(vec2 p,float t)
{
  mat2 rot = mat2(0.5, 0.86, -0.86, 0.5);
  float v = wave(p);
  p.y += t;
  p *= rot;
  v += wave(p.yx);
  p.y += t * .17;
  p *= rot;
  v += wave(p.xy);
  v = abs(1.5 - v);
  v+=pow(abs(sin(p.x+v)),18.0);
  return v;
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
   	vec2 uv = (iResolution.xy - 2.0*fragCoord.xy)/iResolution.y;
    float t = iTime;
	float scale =14.0;
	float speed = .3;
	uv.y += sin(fract(t*0.1+uv.x)*6.28)*0.05;	// wibble
	uv.xy += t*0.08;					// scroll
	vec2 p = uv*scale;
	//p.y+= 1.0/p.y*p.y;
  	float v = get(p,t*speed);
  	v = smoothstep(-3.5,3.5,v);
	vec3 col = vec3(.29, 0.86, 0.4);
    fragColor = vec4(col*v*v, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

