//
// adapted from Original https://www.shadertoy.com/view/sdB3Dh
// Trivial remix of 'FirstFractal314' by Domain314 of shadertoy.com
// Licence CC0
// Adapted, trivialy, for use in VGHD player by ET.

#define iTime u_Elapsed*1./3.14159
#define iResolution u_WindowSize
uniform float u_Elapsed; // The time elapsed in seconds since the beginning of the scene.
uniform vec2 u_WindowSize;  // This is the dimensions of the viewport.

#define iMouse AUTO_MOUSE
#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
#define MOUSE_PRESS vec2(0.0,0.0)
#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )

// alternatively use static mouse definition
//#define iMouse vec4(0.0,0.0, 0.0,0.0)

vec4 texture2D_Fract(sampler2D sampler,vec2 P)
 { return texture2D(sampler,fract(P));
 }
//
#define texture2D texture2D_Fract
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
//
vec2 N (float angle){
    return vec2(sin(angle), cos(angle));
}

void main( void )
{
    vec2 uv = (gl_FragCoord.xy-0.5*iResolution.xy)/iResolution.xy;
    vec2 mouse = iMouse.xy/iResolution.xy;
    uv *= 1.25;
    vec3 col = vec3(0);
    
    uv.x = abs(uv.x);
    uv.y += tan((5./6.)*3.1415)*.5;
    
    vec2 n = N((5./6.)*3.1415);
    float d = dot(uv-vec2(.5,0), n);
    uv -= n*max(0., d)*2.;
    
    //col += smoothstep(.01, .0, abs(d));
    n = N(mouse.y*(2./3.)*3.1415);
    float scale = 1.;
  
   uv.x += .5;

    for (int i=0; i<5; i++){    
        uv *= 3.;
        scale *= 3.;
        uv.x -= 1.5;
        
        uv.x = abs(uv.x);
        uv.x -= .5;
        uv -= n*min(0., dot(uv,n))*2.;
    
    }
    
    d = length(uv - vec2(clamp(uv.x, -1.0, 1.0),0));
    col += smoothstep(1./iResolution.y,1., abs(d/scale));  
    uv /= scale;
    col += texture(iChannel0, uv*2.+iTime*.003).rgb;
    
    gl_FragColor = vec4(col,1.0);
}