#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//ChezMod01.fsh   by   El_Sargo  
//https://www.shadertoy.com/view/7d2BWm
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int       iFrame;
#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//Heavy performance impact 
#define AA 1
#define raymarchSteps 40
#define vanillaMarch
#define rotationSpeed 7.
#define ZERO min(iFrame, 0)
#define post
#define vignet

const float pi = 3.14159265359;
mat3 rotx(float a) { mat3 rot; rot[0] = vec3(1.0, 0.0, 0.0); rot[1] = vec3(0.0, cos(a), -sin(a)); rot[2] = vec3(0.0, sin(a), cos(a)); return rot; }
mat3 roty(float a) { mat3 rot; rot[0] = vec3(cos(a), 0.0, sin(a)); rot[1] = vec3(0.0, 1.0, 0.0); rot[2] = vec3(-sin(a), 0.0, cos(a)); return rot; }
mat3 rotz(float a) { mat3 rot; rot[0] = vec3(cos(a), -sin(a), 0.0); rot[1] = vec3(sin(a), cos(a), 0.0); rot[2] = vec3(0.0, 0.0, 1.0); return rot; }

// Base primitive
float sdBox( vec3 p, vec3 b )
{
    vec3 q = abs(p) - b;
    return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}

//The main part
vec4 map(vec3 p) {
    mat3 rot = rotx(sin (2. * iTime*0.1)*pi + sin(pi * iTime*0.1)*pi)*rotz(cos(iTime/4.)*pi)*roty(sin(iTime/4.+12313.123)*pi);
    int maxI = 8;
    float scale = 1.;
    const float factor = 2.;
    const float baseSize = .7;
    float d = 10e10;
    for (int i=ZERO;i<maxI;i++){ 
        p = abs(p)-.4*factor;
        p *= factor;
        scale /= factor;
        p *= rot;

    }
            d = min(d,
             sdBox(p-vec3(0,.44*factor,0), (vec3(baseSize)))*scale-(0.4*scale)
             );
    return vec4(d,p);
}
#ifndef vanillaMarch 
//https://www.shadertoy.com/view/wlVGRV
vec3 intersection(vec3 ro, vec3 rd){
    
    //Boring variables
    vec3 pos = ro;
    float T = 0.; 
    float h = map(pos).x;

    float omega = 1.;
    float pom = 1.;
    float ph = 1e5;
    vec2 gap = vec2(0.,0.);
    for (int i = 0; i<raymarchSteps; ++i) {
    
        //Position and distance estimation
        vec3 p = ro+T*rd;
        h = map(p).x;
        
        
        //Overstep recovery
        float om = (ph+h)/ph;
        if (om<pom && pom > 1.) { //ph+h<ph*pom
            
            gap = vec2(h,T);
            T+=(1.-pom)*ph;
            pom = 1.;
            
        } else {
            
            //Variable updates
        	T += h * omega;
            ph = h;
            pom = omega;
            
            //Back to the place where the gap opened (foward)
        	if (T>=gap.y-gap.x && gap.y+gap.x > T) {T = gap.y+gap.x*omega; ph = gap.x;};
        }
        
          
        //Dynamic Omega 
        //omega = clamp((omega+om)*.5,1.,3.);
        omega = clamp(omega+(om-omega)*.6,1.,3.);
    }
    return ro+T*rd;;
}
#else
float intersection(vec3 ro, vec3 rd){
    float T = 0.;
    for(int i=0;i < raymarchSteps;i++){
        float dist = map(ro+rd*T).x;
        T += dist;
    
        if(dist <0.01 || dist > 4.)
            break;
    }
    return T;
}
#endif
//iq ---
float softshadow( in vec3 ro, in vec3 rd, float mint, float maxt, float k ){
    float res = 1.0;
    for( float t=mint; t<maxt; )
    {
        float h = map(ro + rd*t).x;
        if( h<0.001 )
            return 0.0;
        res = min( res, k*h/t );
        t += h;
    }
    return res;
}
vec3 calcNormal( in vec3 p, float t ){
    float h = 0.002*t;
    vec3 n = vec3(0.0);
    for( int i=ZERO; i<4; i++ )
    {
        vec3 e = 0.5773*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        n += e*map(p+e*h).x;
    }
    return normalize(n);
}
float calcAO(vec3 pos, vec3 nor){
	float occ = 0.0;
    float sca = .4;
    for( int i=ZERO; i<5; i++ )
    {
            float h = 0.01 + 0.25*float(i)/4.0;
        float d = map( pos+h*nor).x;
        occ += (h-d)*sca;
        sca *= 0.95;
    }
    return clamp( 1.0 - 3.0*occ, 0.0, 1.0 );
}
// ---
vec4 render(vec3 ro, vec3 rd){
    //world info
    float d = intersection(ro,rd);
    vec3 pos = ro+rd*d;
    vec4 d_t = map(pos);
    vec3 trp = d_t.yzw;
   float dis = d_t.x;
   float trd = distance(pos, trp);
    //Shading
     vec3 sun = vec3(1., 1., 1.1);
    float sha = softshadow(pos, sun, 0.1, 5., 1.)*0.5+0.5;
     vec3 nor = calcNormal(pos, d);
    float occ = calcAO(pos, nor);
    float lig = (dot(sun,nor)*0.5+0.5);

    //Colors
    vec3 col = vec3(0);
    vec3 bcl = vec3(log(trd),0.5,cos(trd));
    vec3 scl = vec3(1., 0.8 ,.7);
    vec3 amb = vec3(0.7, 0.9, 1.);
    //
    if (dis < 0.1) {
        //Bones
        col += 0.75*lig*sha*scl*bcl;
        col += 0.6*amb*occ;
    } else
        col = vec3(.7-0.5*abs(rd.y))*scl;
    return vec4(col, 1);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec3   ro = vec3(0, 0, -5.5);
    mat3 yrot = roty(iTime*0.2);
    mat3 xrot = rotx(.9);
           ro*=xrot*yrot;

    vec4 tot = vec4(0);
    
    //Super sampling
    for(int m=0;m<AA;m++){
    for(int n=0;n<AA;n++){
        vec2 o = vec2(float(m),float(n)) / float(AA) - 0.5;
        vec2 u = ((fragCoord+o) / iResolution.xy - 0.5) / vec2(iResolution.y / iResolution.x, 1);
        vec3 rd = normalize(vec3(u, 1));
        tot += render(ro, rd*xrot*yrot) / float(AA*AA);
    }}

    
    #ifdef vignet
    vec2 uv = fragCoord/iResolution.xy-0.5;
    tot *= smoothstep(1.34, 0., length(uv));
    #endif
    
    // Output to screen
    #ifdef post
    fragColor = smoothstep(0.,1.3,tot);
    #else
    fragColor = tot;
    #endif

/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

