#version 330
#extension GL_EXT_gpu_shader4 : enable
// Ese_textureMod01.fsh  by  Eseris

//https://www.shadertoy.com/view/3tfXDN
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int       iFrame; 
#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define pow(a,b) pow(abs(a),(b))

const int MARCHING_STEPS = 150;
const int ALIASING_STEPS = 1;
const float MIN_DIST = 0.;
const float MAX_DIST = 40.;
const float EPSILON = 1e-3;

struct Light {
	vec3 iamb; // ambient intensity
	vec3 idiff; // diffuse intensity
	vec3 ispec; // specular intensity
	vec3 pos;
	float shininess;
};

struct Material {
	vec3 amb; // ambient constant
	vec3 diff; // diffuse constant
	vec3 spec; // specular constant
};

mat2 rot(float a) {
	return mat2(cos(a), sin(a), -sin(a), cos(a));
}

float sdSphere(vec3 p, float radius) {
	return length(p) - radius;
}

float sdBox(vec3 p, vec3 b) {
    vec3 d = abs(p) - b;
	return length(max(d, 0.)) + min(max(d.x, max(d.y, d.z)), 0.);
}

float sdPlane(vec3 p, vec4 n) {
  return dot(p,n.xyz) + n.w;
}

vec3 repeat(vec3 p, vec3 s) {
    return mod(p, s) - .5 * s;
}

float map(vec3 p) {
    float d = 1e10;
    vec3 q = vec3(mod(p.x, 1.), p.yz);
    d = min(d, sdPlane(p, vec4(0, 1, 0, 1.)));
    
    {
        vec3 p2 = p  - vec3(-4, 1, 0);
        p2.zx *= rot(iTime);
    	d = min(d, sdBox(p2, vec3(1, 2, 1)));
    }
    
    d = min(d, sdSphere(p - vec3(4, 0., 1), 1.3));
    d = min(d, sdBox(p - vec3(0, 2, - 2), vec3(2, 2, .01)));
	return d;
}

vec3 mapGradient(vec3 p) {
    vec2 e = vec2(EPSILON, 0.);
	return normalize(vec3(
		map(p + e.xyy) - map(p - e.xyy),
		map(p + e.yxy) - map(p - e.yxy),
        map(p + e.yyx) - map(p - e.yyx)
	));
}

float rayProcess(vec3 camPos, vec3 rayDir, float start, float end) {
	float depth = start;
	for(int i = 0; i < MARCHING_STEPS; ++i) {
		float dist = map(camPos + depth * rayDir);
		if(dist < EPSILON) return depth;
		depth += dist;
		if(dist >= end) return end;
	}
	return end;
}

vec3 rayDirection(float camAngle, vec2 coord) {
	vec2 uv = (coord - .5) * iResolution.xy;
	float focalDist = iResolution.y / 2. / tan(radians(camAngle) / 2.);
	return normalize(vec3(uv, -focalDist));
}


float checkerboard(in vec3 p) {
    vec3 q = floor(p);
    return mod(q.x + q.y + q.z,2.);              
}

// https://iquilezles.org/articles/rmshadows
float calcSoftshadow( in vec3 ro, in vec3 rd, in float mint, in float tmax )
{
    // bounding volume
    const float maxHei = 2.;
    float tp = (maxHei-ro.y)/rd.y; 
    if( tp>0.0 ) tmax = min( tmax, tp );

    float res = 1.0;
    float t = mint;
    for( int i=min(0, iFrame); i<16; i++ )
    {
		float h = map( ro + rd*t );
        res = min( res, 8.0*h/t );
        t += clamp( h, 0.02, 0.10 );
        if( res<0.005 || t>tmax ) break;
    }
    return clamp( res, 0.0, 1.0 );
}

vec3 applyLight(Light light, vec3 p, vec3 rd, vec3 nor) {
    vec3 col = vec3(0.);

    // material        
    vec3 mate = vec3(.3);
    if(p.y < -.999) {
        float f = checkerboard(p);
        mate = 0.15 + f*vec3(0.05);
    }
    else if(abs(p.x) < 2.) {
        vec2 uv = fract(p.yx * .25 - vec2(0, -.5));
        mate = texture2D(iChannel0, uv.yx).rgb;
        //mate = vec3(uv, 0.) * .3;
    }

    // key light
    vec3  lig = normalize(light.pos);
    vec3  hal = normalize( lig-rd );
    float dif = clamp( dot( nor, lig ), 0.0, 1.0 );

    float spe = pow( clamp( dot( nor, hal ), 0.0, 1.0 ),40.0)*
        dif * (0.04 + 0.99*pow( clamp(1.0+dot(hal,rd),0.0,1.0), 6.0 ));
    
    
    dif *= calcSoftshadow(p, lig, .1, 3.);

    col = mate * 3.3*dif*vec3(.80,0.70,0.6);
    col +=      7.0*spe*vec3(1.00,0.70,0.5);

    // ambient light
    float amb = .5;
    col += mate*amb;
    
	return col;
}

vec3 shading(vec3 ro, vec3 rd) {
	Light light;
	light.iamb = vec3(.5, .6, .7);
	light.idiff = vec3(.5);
	light.ispec = vec3(.4);
	light.pos = vec3(-8., 8., 5.);
	light.shininess = 6.;

	//vec3 col = applyLight(mat, light, p, eye);
    vec3 resCol = vec3(0);
    vec3 p = ro;
    float alpha = 1.;
    for(int i = 0; i < 2; ++i) {
        float depth = rayProcess(p, rd, MIN_DIST, MAX_DIST);
    	p += depth * rd;
    	vec3 nor = mapGradient(p);
        
    	vec3 col = applyLight(light, p, rd, nor);
        col *= pow(smoothstep(MAX_DIST, 10., depth), 2.); // fog
        
        resCol += col * alpha;
        alpha *= .25;
        
    	rd = reflect(rd, nor);
        p += rd * 1e-3; // small incr to avoid null dist
    }
    
    
	return resCol;
}

void main (void)
//void mainImage(out vec4 fragColor, in vec2 fragCoord) 
{
    vec3 tot = vec3(0.);
    
    for(int i = 0; i < ALIASING_STEPS; ++i) {
        for(int j = 0; j < ALIASING_STEPS; ++j) {
            vec2 offset = vec2(i, j) / 2. - .5;
            vec3 camPos = vec3(0., 5., 7.);
            vec3 dir = rayDirection(60., (gl_FragCoord.xy + offset) / iResolution.xy);
            
            //float ang = -.3 + .5*sin(.5 * iTime);
            float ang = .5 * iTime;
            camPos.zx *= rot(ang);
            dir.yz *= rot(.5);
            dir.zx *= rot(ang);

            vec3 col = vec3(0.);
            col = shading(camPos, dir);
            
            // gamma
            tot += pow(col, vec3(1. / 1.7));
        }
    }
    
    tot /= float(ALIASING_STEPS * ALIASING_STEPS);
	gl_FragColor = vec4(tot, 1.);
}