#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//CubeSinkMod01.fsh   by GCScholar    
//https://www.shadertoy.com/view/Mffyzf
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PI=3.141;

vec4 SDF(vec3 P)
{   
    float I=0.157, 
    d = length(P.xz), 
    dt = 1., 
    deep = 0.09;
    
    vec2 rt = vec2(log(d)+0.3*iTime, atan(P.z,P.x)+0.03*iTime),
    id = floor(rt/I);
    
    P.y += (d < deep) ? (dt=0.5, deep * smoothstep(0.0, deep, deep - d)) : 0.0;
    
    P = vec3(mod(rt,I)-I/2.,(P.y+sin(iTime)*sin(P.x)*sin(P.z))/d);

    vec3 q = abs(P)-.05;
     
    return vec4(mix(vec3(1.0, 0.5 * fract(sin(dot(id, vec2(13, 78))) * 78.), 0.0), vec3(0), step(0.8, fract(sin(dot(id, vec2(16, 85))) * 78.))),
    dt*((length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0) -  0.02)*d));
}


//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 uv = (2.*fragCoord-iResolution.xy)/iResolution.x; 
    vec3 Peye = vec3(0.36, sin(iTime+PI)*-0.1 + 0.07, -0.27);
    
    vec3 ww = normalize(Peye), uu = (cross(vec3(0.,1.,0.),ww));

    fragColor = vec4(0);
    for(float t=0.; t < 10.;)
    {
        vec3 P = Peye + t*(uu*uv.x+cross(ww,uu)*uv.y-ww);
            
        vec4 C = SDF(P);
        if(C.w < 1e-3)
        {
            vec2 eps = vec2(0.,1e-4);
            vec3 normal = normalize(vec3(
                SDF(P+eps.yxx).w - SDF(P-eps.yxx).w, 
                SDF(P+eps.xyx).w - SDF(P-eps.xyx).w, 
                SDF(P+eps.xxy).w - SDF(P-eps.xxy).w));
       
            float spec = pow(max(dot(normal, normalize(vec3(0.1,1.,0.1)+Peye)), 0.0), 16.0);     
            fragColor = sqrt(C.xyzz*dot(normal,vec3(0.57703))+C.xyzz*0.5*max(dot(normal,vec3(0.,1.,0.)),0.)+spec);
           
            break;
        }
        
        t+=C.w;
    }  
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

