#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// LiveCodingPractice008(1h)Mod01.fsh  by Hirai_worthless   
//https://www.shadertoy.com/view/wtBXRt
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

uniform vec2 mouse;
uniform vec2 resolution;

float PI = 3.14159265;

float genTerra(vec2 uv){
	return sin(uv.x  /2. + iTime / 2.) * sin(uv.y / 2. + iTime / 2.) * 0.5;
}

mat2 genRot(float v){
	return mat2(cos(v),-sin(v),sin(v),cos(v));
}

float map(vec3 p){
	float terrain = -abs(-p.y)-(-2. + genTerra(p.xz));
	
	vec3 q = p;
	vec3 r = p;
	vec3 s = p;
	q.y += mod(iTime * sign(p.x -1.0) + q.z / 5.,2.);
	q.xz = (fract(q.xz / 3. + 0.5) - 0.5) * 3.; 
	q.y *= sign(p.x - 1.0);
	r.xz = (fract(r.xz / 3. + 0.5) - 0.5) * 3.; 
	s.x += mod(iTime * sign(p.y),2.);
	s.x *= sign(p.y);
	s.y = abs(s.y);
	s.y += 2.;
	s.z += 1.5;
	s.yz = (fract(s.yz / 3. + 0.5) - 0.5) * 3.; 
	q.y = (fract(q.y / 2. + 0.5) - 0.5) * 2.; 
	s.x = (fract(s.x / 2. + 0.5) - 0.5) * 2.;
	float sp = min(length(q) - 0.35,length(q - vec3(0.,0.8,0.)) - 0.15);
	sp = min(sp, max(length(q.xz) - 0.05,abs(q.y - 0.4) - 0.5));
	float sp2 = min(length(s) - 0.35,length(s - vec3(0.8,0.,0.)) - 0.15);
	sp2 = min(sp2, max(length(s.yz) - 0.05,abs(s.x - 0.4) - 0.5));
	sp = min(sp,sp2);
	float hole = length(r.xz) - 3. * (1. / (1. +  abs(r.y) * abs(r.y)));
	float cliff = min(abs(r.x) - 0.25,abs(r.z) - 0.25);
	terrain = max(terrain,-hole);
	terrain = max(terrain,-cliff);
	return min(terrain,sp);
}

vec3 getNormal(vec3 p){
	vec3 x = dFdx(p);
	vec3 y = dFdy(p);
	return normalize(cross(x,y));
}

vec4 trace(vec3 o,vec3 r){
	vec4 data;
	float t = 0.;
	for(int i = 0; i < 128; i++){
		vec3 p = o + r * t;
		float d = map(p);
		t += d * 0.5;
	}
	vec3 p = o + r * t;
	vec3 n = getNormal(p);
	return vec4(n,t);
}

vec3 cam(){
	vec3 c = vec3(1.,0.,-2.5 + iTime * 3.);
	//c.xy += vec2(cos(time/4.),sin(time/4.)) * 0.5;
	return c;
}

vec3 ray(vec2 uv,float z){
	vec3 r = normalize(vec3(uv,z));
	r.xz *= genRot(PI / 8.);
	r.yz *= genRot(iTime / 8.);
	r.xy *= genRot(iTime / 4.);
	return r;
}

vec3 getColor(vec3 o,vec3 r,vec4 d){
	float t = d.w;
	vec3 n = d.xyz;
	float tmp1 = dot(r,n);
	vec3 bc = vec3(1. - tmp1 * 0.85);
	vec3 p = o + r * t;
	//bc = min(fract(p.x),fract(p.z+time)) < 0.05 ? vec3(1.0) : bc;
	vec3 cc;
	float at = atan(r.y/r.x) * 2.;
	float tmp2 = at + iTime;
	cc.x = sin(tmp2);
	cc.y = sin(tmp2 + PI * 2. / 3.);
	cc.z = sin(tmp2 - PI * 2. / 3.);
	cc = cc / 2. + 0.5;
	cc = fract(p.z - iTime) < 0.25 ? vec3(1.) : cc;
	bc *= cc;
	
	float fog = 1. / (1. + t * t * 0.015);
	return mix(bc,vec3(0.),1. - fog);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 

	vec2 uv = ( (fragCoord.xy * 2. - iResolution.xy) / iResolution.y );
	vec3 c = cam();
	vec3 r = ray(uv,1.5 + 0.5 * sin(iTime/2.) );
	vec4 d = trace(c,r);
	vec3 color = getColor(c,r,d);

	fragColor = vec4( color, 1.0 );
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

