#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
// MN_StarFieldMod01.fsh  by   MarekNijaki
//https://www.shadertoy.com/view/stSXzV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Shadertoy uses GLSL language.

// UV.
// Default 'UV'.
// vec2 uv = fragCoord/iResolution.xy; 

// Time varying pixel color.
// vec3 col = 0.5 + 0.5*cos(iTime+uv.xyx+vec3(0,2,4));


// Default background colour.
// Output to screen
// fragColor = vec4(col,1.0);



// <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>


// Global constant PI value.
float PI = 3.1415;
// Global constant for UV.
vec2 UV;

// Example how to check 'UV' coordinates values.
// fragColor = vec4(vec3(0)+UV.x,1.0);
// fragColor = vec4(vec3(0)+UV.y,1.0);
vec2 GetUV_WithOriginInTheCenter(in vec2 fragCoord)
{
    // Normalized pixel coordinates (from 0 to 1).
    // Multiply by '0.5' so 'UV' coordinates have their origin/pivot in the middle/center of the screen.
    // 'UV' values will go from '-0.5' to '0' to '0.5'. 
    vec2 UV = (fragCoord - 0.5 * iResolution.xy) / iResolution.y;
    // Return value.
    return UV;
}

// For 'numberOfGridTiles=3' 'UV' values will go from '-1.5' to '0' to '1.5'.
vec2 SetGridTiles(vec2 UV, float numberOfGridTiles)
{ 
    // Set tiles.
    UV = UV * numberOfGridTiles;
    // Return value.
    return UV;
}

// Create grid ID's.
// Can be visualised by 'col.rg +=  gridIDs;'.
// Each cell will have diffrent colour.
vec2 CreateGridIds(vec2 UV)
{
    // Get ID (truncate 'UV' coordinates numbers to only integer value, eg. '2.3' will give '2').
    vec2 IDs = floor(UV);
    // Return value.
    return IDs;
}

// Create grid UV.
vec2 CreateGridUV(vec2 UV)
{
    // WTF? not from -1.5 to 1.5 ???
    // 'UV' goes from '-3' to '3', 'fract()' will return only fractual component of numbers. 
    // Each cell have values from '0' to '1'.
    vec2 gridUV = fract(UV);
    // Move origin of each cell from left bottom corner to middle of each cell.
    // Each cell have values from '-0.5' to '0.5'.
    gridUV = gridUV - 0.5;
    // Return value.
    return gridUV;
}

// Draw debug lines to show outline of the cells.
vec3 DrawDebugCells(vec2 gridUV)
{
    // Create variable to store line colour.
    vec3 col;
    // Draw lines
    if((gridUV.x > 0.49) || (gridUV.y > 0.49))
      col.r = 1.0;
    // Return value.
    return col;
}

// Generate pseudo random value.
// Can be Displayed by 'col = col + GeneratePseudoRandom_FromHash21(gridIDs);'
float GeneratePseudoRandom_FromHash21(vec2 point)
{
    // Twist number so it will lok like random number.
    point = fract(point * vec2(123.34, 456.21));
    point = point + dot(point, point + 45.32);
    // Get random value.
    float randomVal = fract(point.x * point.y);
    // Return value.
    return randomVal;
}

// Randomize positions of grid 'UV' positions.
vec2 RandomizeGridUVPositions(vec2 gridIDs, vec2 gridUV)
{
    // Get random value from '0' to '1'.
    float randomOffsetX = GeneratePseudoRandom_FromHash21(gridIDs);
    float randomOffsetY = fract(randomOffsetX * 34.0);
    // Shift offset so shifted star will not go out of the cell completly (origin of the star was in '0.5, 0.5').
    // Offsets will have values between '-0.5, -0.5' to '0.5, 0.5'.
    randomOffsetX = randomOffsetX - 0.5;
    randomOffsetY = randomOffsetY - 0.5;
    // Randomize values of UV from '0' to '1' based od cells ID's.
    gridUV = gridUV - vec2(randomOffsetX,randomOffsetY);    
    // Return value.
    return gridUV;
}

// Get distance to the center of 'UV'.
float GetDistanceToTheCenter(vec2 UV)
{
    
    // Origin is in the middle. 
    // 'length(UV)' will return distance for each pixel from UV to the middle.
    // You can imagine this as a circle that is going from black to white (from middle to edges).
    // For length value of '0' colour is black , for '1' colour is white.
    float distanceToTheCenter = length(UV);
    // Return value.
    return distanceToTheCenter;
}

// Create smoothstep circle.
// NOT USED BECAUSE: 
//   * In normal world, lighting fall off should go smoothly all the way to the screen edge.
//   * 'smoothstep()' will have hard '0' or '1' values for areas outside of tresholds.
float CreateSmoothstepWhiteCircle(vec2 UV, float lowerCutoff, float upperCutoff)
{
    // Get distance to the center of 'UV'.
    float distanceToTheCenter = GetDistanceToTheCenter(UV); 
    // Smooth out the circle.    
    // 'smoothstep()' takes two cutoff/edges parameters, which determine the lower and higher threshold values for the curve. 
    // When 'In' is lower than 'lowerCutoff', the output is '0', and when 'In' is above 'upperCutoff', the output is '1'.
    // 'smoothstep()' will return interpolates between 'lowerCutoff' and 'upperCutoff' in a similar way to Lerp. 
    // However, the interpolation will gradually speed up from the start and slow down toward the end. 
    // This is useful for creating natural-looking animation, fading and other transitions.
    float darkCircle = smoothstep(lowerCutoff, upperCutoff, distanceToTheCenter);
    float whiteCircle = 1.0 - darkCircle;
    // Return value.
    return whiteCircle;
}

float CreateSmoothWhiteCircle(vec2 UV, float minInnerCircleRadius)
{
    // Get distance to the center of 'UV'.
    float distanceToTheCenter = GetDistanceToTheCenter(UV); 
    
    // Try not divide by 0?!!!
    //if(distanceToTheCenter <> 0)
    // 'clamp(x,min,max)' returns the value of 'x' constrained to the range 'min' to 'max'.
    //whiteCircle = minInnerCircleRadius / clamp(distanceToTheCenter, -1.5, 1.5);
    
    // Create circle
    float whiteCircle = minInnerCircleRadius / distanceToTheCenter;
    // Return value.
    return whiteCircle;
}

// Create cross/flares/rays.
float CreateWhiteCross(vec2 UV, float crossIntensity)
{    
    // Gradient between '-0.5' to '0' to '0.5'.
    float blackToWhiteGradientX = UV.x;
    float blackToWhiteGradientY = UV.y;
    // Gradient between '0.5' to '0' to '0.5'.
    // This will look like vertical and horizontal black lines.
    float whiteToBlackToWhiteGradientX = abs(blackToWhiteGradientX);
    float whiteToBlackToWhiteGradientY = abs(blackToWhiteGradientY);
    // Create cross/flare.
    float blackCross = whiteToBlackToWhiteGradientX * whiteToBlackToWhiteGradientY; 
    // Set thickness/bluriness of cross/flare (higher value will result in clearer lines).
    float crossSize = 1000.0;
    blackCross = blackCross * crossSize;
    // Clamp values between '0' and '1'.
    blackCross = min(1.0, blackCross);
    blackCross = max(0.0, blackCross);
    // Create white cross.
    float whiteCross = 1.0 - blackCross;
    // Set intensity.
    whiteCross = whiteCross * crossIntensity;
    // Return value.
    return whiteCross;
}

// Return rotation angle matrix.
// 'PI' is aroung '3.1415'
// '360' degrees is two 'PI' radians.
// '180' degrees is 'PI' radians.
mat2 RotationAngle(float angle)
{
    float sinus = sin(angle);
    float cosinus = cos(angle);
    return mat2(cosinus,-sinus,sinus,cosinus);
}

// Create star.
vec3 CreateStars(vec2 gridIDs, vec2 UV, float starIntensity, float innerCircleRadius, float crossIntensity, 
                 float minRange, float maxRange, vec3 col)
{
    // Create circle.
    float whiteStar = CreateSmoothWhiteCircle(UV, innerCircleRadius);
        
    // Applay first cross/flares/rays.
    whiteStar = whiteStar + CreateWhiteCross(UV, crossIntensity);
    // Rotate 'UV' around '45' degrees angle.
    UV = UV * RotationAngle(PI / 4.0);
    // Applay second cross/flares/rays.
    whiteStar = whiteStar + CreateWhiteCross(UV, crossIntensity);
    
    // Get distance to the center of 'UV'.
    float distanceToTheCenter = GetDistanceToTheCenter(UV); 
    // Cut star.
    // Cut is needed, because in some cases, glow and flares could go out of the cell - for values bigger than '0.5'.
    // That would be fine because neighbourhood cells will take care of drawing appropiate parts of star, but it can't go
    // further - eg. 2 or more cells, because it would lead to artifacts.
    minRange = clamp(minRange, 0.0, 0.5);
    maxRange = clamp(maxRange, 0.0, 1.0);
    whiteStar = whiteStar * smoothstep(maxRange, minRange, distanceToTheCenter); 
    
    // Apply intensity.
    whiteStar = whiteStar * starIntensity;
    
    
    // Convert white star to star with colour.
    vec3 star = vec3(whiteStar);
    // Apply colour.    
    star = star * col;
    
    // Return value.
    return star;
}

// Create random colour.
vec3 CreateRandomColour(vec2 gridIDs, float starIntensity)
{
    // Generate random value.
    float randomVal = GeneratePseudoRandom_FromHash21(gridIDs);
    // Rate of colour changes.
    float colourChangeRate = 2.0;
    
    // Because small values are very close to each other, colour components will look almost the same.
    // To avoid that we can multiply those components by some big number to disperse them all over 'sin()' method.
    //float colourComponentsDispersionMagnifier = 1.0;
    //vec3 col = sin(vec3(0.2, 0.3, 0.9) * randomVal * colourComponentsDispersionMagnifier) / 2.0 + 0.5;
    
    // Create random colour.
    // 'sin(vec3(...))' will just do 'sin()' for each component separatly.
    // '* iTime' will multiply 'sin()' outcomes over time value. 
    // Each colour component (RGB) will change with diffrent rates, because each have diffrent multiplication exponent (0.2, 0.3, 0.9). 
    // Colour components have values between '0.0' and '1.0'. 'Sin()' goes from '-1.0' to '1.0'.
    // '/ 2.0' will result in values between '-0.5' and '0.5'.
    // '+ 0.5' will result in values between '0.0' and '1.0', so appropiate for colour components.    
    vec3 colour = sin(vec3(0.2, 0.3, 0.9) * randomVal * colourChangeRate * iTime) / 2.0 + 0.5;
    
    // Eliminate colours that we don't like (in this case remove most of green).
    //colour = colour * vec3(1.0, 0.3, 1.0);
    colour = colour * vec3(0.24, 0.21, 1.0);
    // Set bigger stars more blue.
    colour = colour * vec3(1.0, 1.0, 2.0 * starIntensity);
    
    // Return value.
    return colour;
}

// Get mouse positon.
vec2 GetMousePos()
{
  return (iMouse.xy - (iResolution.xy * 0.5)) / iResolution.y;
}

// Get mouse input.
vec2 GetMouseInput()
{
  vec2 mousePos = GetMousePos();
  return mousePos * 5.0;
}

// Create stars.
// Also for each star draw parts of it that went out of the cell (neighbour cells will generate that star parts).
vec3 CreateStarsWithNeighboursContributions(float densityOfStars, float layerRandomOffset, mat2 layerAngle)
{
    // Allow to look over star field (normal looking around).
    //vec2 UVtmp = SetGridTiles(UV+GetMouseInput(), densityOfStars);
    // Set grid tiles. 
    vec2 UVtmp = SetGridTiles(UV, densityOfStars);
    // Allow to look over star field (paralax effect).
    UVtmp = UVtmp + GetMouseInput();    
    // Set rotation of layer.
    UVtmp = UVtmp * layerAngle;
    // Set random offset of layer.
    UVtmp = UVtmp + layerRandomOffset;
    // Create grid ID's.
    vec2 gridIDs = CreateGridIds(UVtmp);
    // Create grid 'UV'.
    vec2 gridUV = CreateGridUV(UVtmp);    
    // Create star variable.
    vec3 stars;
    // For each cell, add contributions from neighbourhood cells.
    for(int x=-1; x<=1; x++)
      for(int y=-1; y<=1; y++)
      {
        // Get neighbour offset.
        vec2 offset = vec2(x,y);
        // Compute offseted grid IDs and UV.
        vec2 offsetedGridIDs = gridIDs+offset;
        vec2 offsetedGridUV = gridUV-offset;
        // Randomize grid 'UV' positions.
        vec2 gridUV2 = RandomizeGridUVPositions(offsetedGridIDs, offsetedGridUV);
        // Generate random star intensity (will also affect star size little bit).
        float starIntensity = GeneratePseudoRandom_FromHash21(offsetedGridIDs);
        starIntensity = max(0.5, starIntensity);
        // Compute inner circle radius (below '0.01' stars become invisible).
        // Big values make stars look like big glowy bulbs.
        float innerCircleRadius = max(0.065, 0.065/densityOfStars);
        // Compute star cross intensity (only stars with big intensity will have cross turn on).
        float crossIntensity = smoothstep(0.8, 1.0, starIntensity);
        crossIntensity = min(0.25, crossIntensity);        
        // Set min and max range.
        float minRange = 0.4; 
        float maxRange = 1.0;
        // Create random colour.
        vec3 col = CreateRandomColour(offsetedGridIDs, starIntensity);
        // Create stars.
        stars = stars + CreateStars(gridIDs, gridUV2, starIntensity, innerCircleRadius, crossIntensity, minRange, maxRange, col);
      }    
    // Draw debug cells.
    //stars = stars + DrawDebugCells(gridUV);
    // Return value.
    return stars;
}

// Get fade factor, depending on layer depth.
float GetFadeFactor(float depth)
{
    // This is only to show other way, how to achive similar result as smoothstep.
    //if(depth > 0.9) 
    //{
      // 0.9 * 10 => 9.0 => fract() => 0.0
      // 0.91 * 10 => 9.1 => fract() => 0.1
      // 0.92 * 10 => 9.2 => fract() => 0.2
      // 0.99 * 10 => 9.9 => fract() => 0.9
      //float interpolation = fract(depth*10.0);
      // Fade out last part of animation (start will become more transparent whe they are very close to screen).
      //fadeFactor = mix(fadeFactor, 0.0, fract(depth*10.0));
    //}
    
    // Last part of depth should fade out again.
    float fadeFactor = depth * smoothstep(1.0, 0.8, depth);
    // Return value.
    return fadeFactor;
}

// Create multiple layers of stars.
vec3 CreateStarsLayers(float numOfLayers, float densityOfStars)
{
  // Caculate animation speed.
  float passThroughAnimationSpeed = iTime * 0.1;
  float rotateAnimationSpeed = iTime * 0.01;
  // Stars layers.
  vec3 starsLayers;
  // Create layers of stars
  for(float i=0.0; i<1.0; i += 1.0/numOfLayers)
  {
    // Depth of layer will change from small value to '1.0' over time. 
    // After it reach '1.0' depth will be shifted to small value and again start increasing.
    float depth = fract(i+passThroughAnimationSpeed);
    // Scale influence how many grid tiles is on given layer.
    // To increase number of stars, scale must increase also.
    // As for layers goes, each of them should have diffrent size of stars (from layers with low scale to high scale).
    // Changing scale of each layer over time will give sense of passing through the stars.
    float scale = mix(densityOfStars + numOfLayers, 0.5, depth);
    // Compute layer random positon (so layers stars will not align into lines).
    float layerRandomOffset = i * 453.23;
    // Compute layer angle.
    mat2 layerAngle = RotationAngle(PI * rotateAnimationSpeed);
    // Layers that are far from screen (have low scale) should be fading from '0.0' to '1.0', as scale increase.
    // This will prevent 'poping out' artifact when layers are shifted to the back (their scale is set to low number).
    float fadeFactor = GetFadeFactor(depth);
    // Create mulitple layers of stars.
    starsLayers = starsLayers + CreateStarsWithNeighboursContributions(scale, layerRandomOffset, layerAngle) * fadeFactor;
  }
  // Return value.
  return starsLayers;
}


// Main function.
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{    
    // Get UV with origin/pivot in the middle/center of the screen.
    UV = GetUV_WithOriginInTheCenter(fragCoord);
    // Create black colour.
    vec3 col = vec3(0);
    // Create stars layers.
    col = col + CreateStarsLayers(7.0, 15.0);
    // Output to screen.
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

