#version 330
#extension GL_EXT_gpu_shader4 : enable
//SynapsesMod01.fsh  by  Pyrolykos 

//https://www.shadertoy.com/view/3ljSDD
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.0177
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract
#define texture texture2D
#define SF 2.0
#define TF 0.5  // was 1.3

float ellipse(vec3 pos, vec3 stretch, float sr) {
    return length(pos/stretch) - sr;
}

float map(vec3 pos) {
    vec3 ePos = vec3(sin(iTime*TF)*cos(pos.x*SF)+cos(iTime*TF)*sin(pos.z*SF),
                     2.0*cos(pos.y*SF)+sin(pos.z*SF)-cos(pos.x*SF),
                     sin(iTime*TF)*cos(pos.x*SF)+cos(iTime*TF)*sin(pos.z*SF));
    //float d = ellipse(ePos, vec3(1.0,1.3,1.0), 0.5);
    float d = ellipse(ePos, vec3(1.0,1.4,1.0), 0.5);
   
    // Just regrab tex here to use for bumpiness
    //vec2 tex_uv = pos.xz - iTime*(0.0, 0.5);
    vec2 tex_uv = pos.xz - iTime*(0.0, 0.5);
    vec3 tex_val = texture(iChannel0, tex_uv).xyz;
    float th = length(tex_val);
    return d-0.1*th;
}

vec3 normal(vec3 pos) {
    vec2 eps = vec2(0.0001, 0.0);
    vec3 res = vec3 (map(pos+eps.xyy) - map(pos-eps.xyy),
    map(pos+eps.yxy) - map(pos-eps.yxy),
    map(pos+eps.yyx) - map(pos-eps.yyx));
    return normalize(res);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // normalized pixel coords
    vec2 uv = (2.0*gl_FragCoord.xy-iResolution.xy)/iResolution.y;
    vec3 rd = normalize(vec3(uv.xy, -1.5));
    vec3 ro = vec3(3.0,3.0,11.0);
   
    float t = 0.0;
    vec3 pos;
    for (int i = 0; i < 100; i++) {
        pos = ro + t*rd;
       
        float h = map(pos);
       
        t += 0.2*h;
       
        if (t > 30.0) break;
    }
   
    vec3 col = vec3(0.0);
    if (t < 30.0) {
        vec3 sun_dir = normalize(vec3(0.4, 0.8, 0.4));
        vec3 sun_dir2 = normalize(vec3(0.4, -0.8, 0.4));
        vec3 norm = normal(pos);
        float sun_val = clamp(dot(norm, sun_dir), 0.0, 1.0);
        float sun_val2 = clamp(dot(norm, sun_dir2), 0.0, 1.0);
        vec2 tex_uv = pos.xz - iTime*(0.0, 0.5);
        vec3 tex_val = texture(iChannel0, tex_uv).xyz;
        col = (sun_val+0.15*sun_val2)*tex_val*pos.xyz;
        col = pow(col, vec3(0.45));
    }
   
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}