#version 330
#extension GL_EXT_gpu_shader4 : enable
// Quasicrystal1Mod01.fsh by RossBencina

//https://www.shadertoy.com/view/Xs2GDR
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.628318  //0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

// Quasicrystal based on Matt Henderson's blog post:
// http://blog.matthen.com/post/51566631087/quasicrystals-are-highly-structured-patterns-which	
// click and drag the mouse for interactivity.
// Left/Right: scale
// Up/Down: number of waves

// normalized mouse position. Default values
float mouseX = 0.8;
float mouseY = 0.4;
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	if( iMouse.x != 0.0 ) { // once Shadertoy mouse pos is initialized use that:
		mouseX = float(iMouse.x) / float(iResolution.x);
		mouseY = float(iMouse.y) / float(iResolution.y);
	}
	
	float speed = 2.0;
	float scale = 0.1;
	const int N_MAX = 20;
	float n = 7.0;
	
	// click and drag up and down to change the number of symmetries (up is more)
	// n is the number of waves. we allow a fractional number and fade out the final one below
	n = mouseY * float(N_MAX);
	
	// click and drag left and right to adjust scale (left zooms out)
	scale = 0.1 + (1.0-mouseX);
	
	const float pi = 3.1415926;
	
	// accumulate n waves
	float S = 0.0;
	for( int i=0; i < N_MAX; ++i){
	
		// allow for n+1 waves
		if( i >= (int(n)+1) )
			break;
		
		float theta = pi * float(i)/float(n);
			
		// center coordinates in viewport
		float x = gl_FragCoord.x - (iResolution.x*0.5);
		float y = gl_FragCoord.y - (iResolution.y*0.5);
		
		float wp = x*cos(theta) + y*sin(theta);
		float w = sin(wp*scale + iTime*speed);
		
		// fade out the final wave in proportion to n-floor(n)
		if( i == int(n) )
			w *= n-floor(n);		
		
		// accumulate 
		S += 3.0 * w / n;
	}
	
	// sin/cos hackery to get some colours
	gl_FragColor = vec4(sin(S-0.1)*.6,cos(S+.3)*.9,cos(S+.1)*1.1,1.0);
	
	// greyscale version:
	//gl_FragColor = vec4(S,S,S,1.0);
}