#version 330
#extension GL_EXT_gpu_shader4 : enable
// Dilbert2Mod01.fsh  by  SnoopethDuckDuck

//https://www.shadertoy.com/view/7d2GRK
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float random (vec2 st) {
    return fract(sin(dot(st.xy,
                         vec2(12.9898,78.233)))*
        43758.5453123);
}

const float pi = 3.14159;
const float pi2 = 2. * pi / 3.;
const float pi3 = 4. * pi / 3.;
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from 0 to 1)
    vec2 uv = gl_FragCoord.xy/iResolution.xy;
 // float b = 0.5 * (1. + cos( iTime / 9.));
//uv = b * uv + (1.-b ) *floor( 128. * uv) / 128.;
vec2 dir = uv.xy + (0.1 + 0.05 * cos(0.05 *iTime)) * cos(10. * uv.xx + 0.5 * iTime) - 0.5;
float t = 0.2 * iTime;
float l = pow(cos( 2. * t / 3.),2.);
float d = (10. * l + 2. * (1. - l))* length(dir);
//d = b * d + (1.-b ) *floor ( 2. * d) / 2.;
float theta =  atan( dir.y,dir.x);

float val =  sin(acos(sin(uv.y - t ) * sin(1. * theta+t)));
float val2 =  sin(acos(sin(uv.y - t + pi2) * sin(2. * theta +t )));
float val3 = sin(acos(sin(uv.y - t + pi3) * sin(3. * theta + t )));
    // Time varying pixel color
   // float r = random(uv.xx) * ( (1.-l) * d + l * 16. * d * (1.-d)  *(1. -d) * d);
    float r = random(uv.xx) * d * d * d;
    vec3 col = vec3(
    smoothstep(val, r ,  sqrt(val2 * val3)),
    smoothstep(val2,r ,  sqrt(val * val3)),
    smoothstep(val3,r ,  sqrt(val* val2))    
    );
    
    float q = 0.5 * (1. + cos(t / 3.));
    col = vec3(col.x + q * col.y, col.y + q * col.z, col.z + q * col.x);
    //col = vec3(min(col.x, col.y),min(col.y, col.z),min(col.z, col.x));
    // Output to screen
    gl_FragColor = vec4(col,1.0);
}