#version 130
#extension GL_EXT_gpu_shader4 : enable
// getErraticWaveMod01.fsh  by  TestCoder
 
//https://www.shadertoy.com/view/fd2XW1
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float cbrt(float number) {
    return pow(abs(number), 1. / 3.);
}

float getErraticWave(float number) {
    float scale = 1.;

    return (
        cbrt(sin(number))
      + pow(
          sin(
              number + iTime / 3.
          ),
          3.
        )
    ) / scale;
}

vec3 getErraticPattern(float x, float y, vec2 uv) {
    float stretch = 2.;
    float mainDance = getErraticWave(
        getErraticWave(uv.y + uv.x)
      + getErraticWave(uv.y + -uv.x)
      + getErraticWave(-uv.y + uv.x)
      + getErraticWave(-uv.y + -uv.x)
    );

    return (
        getErraticWave(
            x
        ) + getErraticWave(
            y
        )
    ) * stretch * (1. - vec3(
        mainDance * (
            sin(
                iTime / 20. + .5
            ) + 1.
        )
    ,
        mainDance * (
            sin(
                iTime / 4. + .25
            ) + .5
        )
    ,
        mainDance * (
            sin(
                iTime / 4. + 1.
            ) + .25
        ) + mainDance
    ));
}

// mainImage( out vec4 fragColor, in vec2 fragCoord ) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    // Normalized pixel coordinates (from -.5 to .5)
    vec2 uv = fragCoord/iResolution.xy-.5;

    uv.x *= iResolution.x/iResolution.y;

    float zoomOut = 10.;

    vec3 rgb = getErraticPattern(
                uv.x, uv.y, uv * zoomOut
            ) + getErraticPattern(
                -uv.x, uv.y, uv * zoomOut
            ) + getErraticPattern(
                uv.x, -uv.y, uv * zoomOut
            ) + getErraticPattern(
                -uv.x, -uv.y, uv * zoomOut
            );

    // Output to screen
    fragColor = vec4(1. - rgb, 1.);
    return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb );

}
// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.