#version 330
#extension GL_EXT_gpu_shader4 : enable
// IceWalkerMod01.fsh by antoinefortin

//https://www.shadertoy.com/view/WssBW7
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define HALFPI 1.57079632679
#define farClipPlane 35.
#define nearClipPlane 0.001
#define normalEpsilon 0.0021

vec2 rotate(vec2 pos, float angle)
{
	float c = cos(angle);
    float s = sin(angle);
    
    return mat2(c,s,-s,c) * pos;

}



float plane(vec3 pos)
{	
    
    vec3 q = pos;
    
	return q.y;
}

float sdBox( vec3 p, vec3 b )
{
  vec3 q = abs(p) - b;
  return length(max(q,0.0)) + min(max(q.x,max(q.y,q.z)),0.0);
}
float sdPyramid( vec3 p, float h)
{
  float m2 = h*h + .25;
    
  p.xz =abs(p.xz);
  p.xz = (p.z>p.x) ? p.zx : p.xz;
  p.xz -= 0.5;

  vec3 q = vec3( p.z, h*p.y - 0.5*p.x, h*p.x + 0.5*p.y);
   
  float s = max(-q.x,0.0);
  float t = clamp( (q.y-0.5*p.z)/(m2+0.25), 0.0, 1.0 );
    
  float a = m2*(q.x+s)*(q.x+s) + q.y*q.y;
  float b = m2*(q.x+0.5*t)*(q.x+0.5*t) + (q.y-m2*t)*(q.y-m2*t);
    
  float d2 = min(q.y,-q.x*m2-q.y*0.5) > 0.0 ? 0.0 : min(a,b);
    
  return sqrt( (d2+q.z*q.z)/m2  ) * sign(max(q.z,-p.y));
}


vec2 sdObj1(vec3 pos)
{
    
    /*
	pos.y -= 4.;
    pos.xz = rotate(pos.xz, iTime);
    pos.yz = rotate(pos.yz, iTime * 0.5);
    float d = sdBox(pos, vec3(2.0));
	*/
     
    
    vec3 q = pos;
   
    q.z = mod(q.z+ 5.0, 10.) -5.;
	q.x = mod(q.x+ 2.5, 5.) -2.5;
  
   	//q.xy = rotate(q.yz, iTime * sin(iTime * .005));
    
    /*
    q.xz = rotate(q.xz, iTime);
	q.xz = rotate(q.xz, iTime);
    q.xz = rotate(q.xz, iTime);
	*/    
   	//q.xy = rotate(q.xy,);
    
    float cp1 = 2.0;
    q.y -= cp1;
	q.yz = rotate(q.yz, iTime);
    q.xz = rotate(q.xz, iTime * 2.);
    
    float p1 = sdPyramid(q,1.);
    q.xy = rotate(q.xy, 3.1415);
   	
    q.xz = rotate(q.xz, iTime * 2.);
    float p2 = sdPyramid(q,1.);
    
    ;
    float d  = min(p1, p2);
    
    vec2 res = vec2(d, 12.0);
    
    return res;
}

float sphere(vec3  pos, float radius)
{	
    pos.y -= 4.0;
    return length(pos) - radius;
}

vec2 map(vec3 pos)
{
    
    //float d2 = plane(pos);
    vec2 d1 = sdObj1(pos);
    float d2 = pos.y; 
    
    
    
    return (d2 < d1.x) ? vec2(d2, 1.0) : d1;
    
}

vec2 castRay(vec3 ro, vec3 rd)
{	
    float m = -1.0;
    float t = 0.0;
    for(int i = 0; i < 256; i++)
    {
    	vec3 pos = ro + t * rd;
        
        vec2 h = map(pos);
        
        m = h.y;
        if(h.x < 0.001)
        {
        	break;
        }
        t += h.x;
        
        if(t > farClipPlane) break;
        
    }
    
    if(t > farClipPlane) m = -1.0;
    
    return vec2(t,m);
}



vec3 computeNormal(vec3 pos)
{
    vec2 eps = vec2(0.1, 0.0);
    return normalize(vec3(
        map(pos + eps.xyy).x - map(pos - eps.xyy).x,
        map(pos + eps.yxy).x - map(pos - eps.yxy).x,
        map(pos + eps.yyx).x - map(pos - eps.yyx).x
    ));
}

vec3 material(vec3 pos)
{
    return vec3(smoothstep(0.4, 0.41, fract(pos.x + sin(pos.z * 0.4 + iTime))));
}

void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
     vec2 mouse = iMouse.xy / iResolution.xy;
    
    vec2 uv = (gl_FragCoord.xy -.5 * iResolution.xy) / iResolution.y;
    
    
	if(uv.y < 0.)
    {
    	vec2 p = vec2(uv);    
        float ba = texture2D(iChannel0, p * 1.).x;    
        
        ba *= .5 * 2.;
    	uv.y = abs(uv.y * 1.5) * ba ;
        uv.y += sin(uv.y);
    }
    
    
   // uv.y = abs(uv.y);
	//uv.x = abs(uv.x);
    float angle = iTime;
    
    vec3 ro = vec3(iTime + abs(sin(iTime)), 1.0, iTime *5.5);
    
    // Rayon que l'on envoie dans l'espace pour chacuns des pixels
    vec3 rd = normalize(vec3(uv.x, uv.y, 1));    
    
    

     vec3 col = vec3(0.4, 0.75, 1.0) - 0.7 * rd.y;
               
	vec2 tm = castRay(ro, rd);

		// If material is positive
        if(tm.y > 0.)
        {
			

            float t = tm.x;
            vec3 pos = ro + t * rd;
            vec3 nor = computeNormal(pos);
            vec3 sunPosition = vec3(1.,12.,-12.);
            vec3 sundir = normalize(sunPosition);
            vec3 mate = vec3(.15);


            float sundif = clamp(dot(nor, sundir), 0.0, 1.0);
            float sun_sha = smoothstep(castRay(pos + nor * 0.001, sundir).y, 0.0, 1.0);
            float sky_dif = clamp(0.5 + 0.5 * dot(nor,vec3(0.0,1.0,0.0)), 0.0, 1.0);
            float bou_dif = clamp(0.5 + 0.5 *dot(nor,vec3(0.0,-1.0,0.0)), 0.0, 1.0);

            col = mate * vec3(t * 0.5, t * 0.25, 1.0) * (sundif) * sun_sha;
            col += mate * vec3(0.0075, 0.0008, 0.09) * sky_dif;
            col += mate * vec3(0.075, 0.003, 0.02) * bou_dif;	
            
            //col *= 1.25;
			// Floor material
           	if(tm.y == 1.0)
            {
                
            	col += vec3(.24, 0.8,.5);
                float f = sin(5.0 * pos.x) * sin(5.0 * pos.z);
                col += f;
            }
            // Cube Material
            if(tm.y == 12.0)
            {
                
                //col = vec3(smoothstep(0.4, 0.241, fract(pos.x + sin(pos.y * 0.4 + iTime))));
            	//col = mate;
                col += mate;
                col += (sky_dif * mate);
            }
            
            
            
        }

    
    	//vec3 depth = castRay(ro,rd).x;
	
    // Calculation de fog biwn ghetto (Plus c'est loin plus ces tdark)
	// float fog = 1.0 / (1.0 + depth.x * depth.x * 0.1);
	
    //frag color
    float t = castRay(ro, rd).x;
    
    float fog = 1.0 / t;
    
    vec3 fogc = vec3(0.0, 0.0, (sin(iTime) + 2. ) / 2.) * fog;
    
    // Output to screen
    gl_FragColor = vec4(sqrt(col), 1.0);
}