#version 330
#extension GL_EXT_gpu_shader4 : enable
//MobiusMod01.fsh  by  dila

//https://www.shadertoy.com/view/MsSSRV
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

vec2 cmul(vec2 a, vec2 b) {
    return a * mat2(b.x, -b.y, b.y, b.x);
}

vec2 cinv(vec2 z) {
    return vec2(z.x, -z.y) / dot(z, z);
}

vec2 cdiv(vec2 a, vec2 b) {
    return cmul(a, cinv(b));
}

vec2 invmobius(vec2 z, vec2 a, vec2 b, vec2 c, vec2 d) {
    return cdiv(cmul(d,z)-b, a-cmul(c,z));
}

vec2 map(vec2 p) {
    float time = iTime * 0.1;
    vec2 t = vec2(sin(time), 0.0);
    vec2 a = vec2(cos(time*5.0), sin(time*5.0));
    vec2 b = vec2(0.0, 0.0);
    vec2 c = t * cos(iTime * 0.25) * 10.0;
    vec2 d = vec2(1.0, 1.0);
    return invmobius(p, a, b, c, d);
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 aspect = vec2(iResolution.x / iResolution.y, 1.0);
    
    vec2 a = ((gl_FragCoord.xy + vec2(0.0, 0.0)) / iResolution.xy * 2.0 - 1.0) * aspect;
    vec2 b = ((gl_FragCoord.xy + vec2(1.0, 0.0)) / iResolution.xy * 2.0 - 1.0) * aspect;
    vec2 c = ((gl_FragCoord.xy + vec2(1.0, 1.0)) / iResolution.xy * 2.0 - 1.0) * aspect;
    vec2 d = ((gl_FragCoord.xy + vec2(0.0, 1.0)) / iResolution.xy * 2.0 - 1.0) * aspect;

    vec2 ma = map(a);
    vec2 mb = map(b);
    vec2 mc = map(c);
    vec2 md = map(d);
    
    float da = length(mb-ma);
    float db = length(mc-mb);
    float dc = length(md-mc);
    float dd = length(ma-md);
    
    /* try to anti-alias by flattening the colours when the transformation causes too much stretch */
	float stretch = max(max(max(da,db),dc),dd);
    float aa = 1.0 / (1.0 + stretch * stretch * 10000.0);
    
    vec2 block = floor(ma * 10.0 + 0.5);
	vec2 square = abs(ma - block / 10.0);
    square *= aa;
    float an = iTime * 0.1 ;
    vec2 rot = cmul(square, vec2(cos(an), sin(an)));
    
    vec3 r;
    r.x = (0.5 + sin(rot.x * 100.0 + iTime * 0.5) * 0.5);
    r.y = (0.5 + sin(rot.y * 100.0) * 0.5);
    r.z = (0.5 + sin(square.y * 100.0 + iTime) * 0.5);
    
    gl_FragColor = vec4(r, 1.0);
}
