#version 330
#extension GL_EXT_gpu_shader4 : enable
// kompotMod01.fsh  by  foran

//https://www.shadertoy.com/view/tl2XWt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.177 //0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI 3.14158
#define TAU PI*2.
#define t iTime*.13

float sphere (vec3 p, float r) { return length(p)-r; }
float cyl (vec2 p, float r) { return length(p)-r; }
float sdBox(vec3 p,vec3 b)
{ vec3 d=abs(p)-b; return length(max(d,0.)) +min(max(d.x,max(d.y,d.z)),0.);// remove this line for an only partially signed sdf
}
vec3 moda (vec2 p, float count) {
  float an = TAU/count;
  float a = atan(p.y,p.x)+an/2.;
  float c = floor(a/an);
  a = mod(a,an)-an/2.;
  c = mix(c, abs(c), step(count/2., abs(c)));
  return vec3(vec2(cos(a),sin(a))*length(p),c); 
}
mat2 rot (float a) { float c=cos(a),s=sin(a); return mat2(c,-s,s,c); }

float smin (float a, float b, float r) {
  float h = clamp(.5+.5*(b-a)/r, 0.,1.);
  return mix(b,a,h)-r*h*(1.-h);
}

float map (vec3 p);

vec3 normal (vec3 p){
  float e = 0.01;
  return normalize(vec3(map(p+vec3(e,0,0))-map(p-vec3(e,0,0)),
  map(p+vec3(0,e,0))-map(p-vec3(0,e,0)),
map(p+vec3(0,0,e))-map(p-vec3(0,0,e))));
}

float iso (vec3 p, float r) { return dot(p, normalize(sign(p)))-r; }

float map (vec3 p) {
  p.xy *= rot(t);
  p.yz *= rot(t*.5);
  p.xz *= rot(t*.3);
  p.xz *= rot(p.y*.3+t);

  float cyl2 = cyl(p.xz, .3+.8 * (.5+.5*sin(p.y*1.+t*10.)));
  float a = atan(p.y,p.x);
  float l = length(p.xy);
  float c = 1.;//   10
  p.x = mod(abs(l*.95-4.)+t*1., c)-c/2.;
  //p.y = cos(a)*10.;

  vec3 p1 = moda(p.xz, 8.);//      20
  float wave1 = sin(t*10.+p.y*0.5+p1.z);
  p1.x -= 2.+(.5+.5*wave1);
  p.xz = p1.xy;
  float celly = 3.;
  vec3 p2 = p1;
  p.y = mod(p.y+t*10.+p1.z,celly)-celly/2.;
  float sph1 = sphere(p, 0.2+.2*(.5+.5*sin(p.y+t*10.)));
  float cyl1 = cyl(p.xz, 0.2*wave1+.02);
  float box=sdBox(p-vec3(0,-wave1,0),vec3(2.*.125));
  float box1=sdBox(p-vec3(0,0,0),vec3(.3+.8*(.5+.5*sin(t*10.))));
  float scene=smin(cyl1,box,.3);
  scene=smin(scene,cyl2,.3);
    
  p.y = mod(p.y+t*10.,celly)-celly/2.;
  float iso1 = iso(p,0.2+.2*wave1);
  scene = smin(scene, iso1, .13);
  return scene;
}
//void mainImage(out vec4 fragColor,in vec2 fragCoord)
void main (void)
{
  vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.y;
  vec3 eye = vec3(uv, -5.), ray = (vec3(uv,.5)), pos = eye;
  int ri = 0;
  for (int i = 0; i < 50; ++i) {
    float dist = map(pos);
    if (dist < 0.01) {
      break;
    }
    pos += ray*dist;
    ri = i;
  }
  vec3 n = normal(pos);
  float ratio = float(ri)/50.;
  vec4 color = vec4(1.);
  color.rgb = n*.5+.5;
  color.rgb *= 1.- ratio;
  gl_FragColor = vec4(color.rgb,1.0);

}