#version 330
#extension GL_EXT_gpu_shader4 : enable
//GatheringMod01.fsh by gaz
//https://www.shadertoy.com/view/llSSWt
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define PI  3.14159265359

mat2 rotate(float a)
{
    return mat2(cos(a), sin(a), -sin(a), cos(a));
}

// iq's function
float smin( float a, float b )
{
    float k = 0.06;
	float h = clamp( 0.5 + 0.5*(b-a)/k, 0.0, 1.0 );
	return mix( b, a, h ) - k*h*(1.0-h);
}

// https://www.shadertoy.com/view/4tX3DS
vec2 fold(in vec2 p, in float a)
{
    p.x = abs(p.x);
    vec2 v = vec2(cos(a), sin(a));
    for(int i = 0; i < 5; i++)
    {
        p -= 2.0 * min(0.0, dot(p, v)) * v;
        v = normalize(vec2(v.x - 1.0, v.y));
    }
    return p;    
}

vec2 sfold(in vec2 p, in float a)
{
    p.x = abs(p.x);
    vec2 v = vec2(cos(a), sin(a));
    for(int i = 0; i < 5; i++)
    {
        // a very subtle smooth minimum ?
        p -= 2.0 * smin(0.0, dot(p, v)) * v;
        v = normalize(vec2(v.x - 1.0, v.y));
    }
    return p;    
}

float map(in vec3 p)
{   
    int type = 0;
    if (p.x > 0.0) type = 1;
    p.yz *= rotate(iTime * 0.1);
    p.zx *= rotate(iTime * 0.05);
	if (type == 0)
    {
	    p.xy = fold(p.xy, PI / 2.0);
    } else {
    	p.xy = sfold(p.xy, PI / 2.0);
        
    }
    p.z = abs(p.z) - 0.5;
    p.z = abs(p.z) - 0.8;
    p.z = abs(p.z) - 0.7;
    p.z = abs(p.z) - 0.5;
    p.z += sin(length(p.xy) * 1.5 + iTime * 2.0) * 0.15;
    p.y += iTime * 0.5;
    p.y = mod(p.y, 0.4) - 0.2;
    return length(p) -  0.1;
}

vec3 calcNormal( in vec3 pos )
{
    vec2 e = vec2(1.0, -1.0) * 0.002;
    return normalize(
        e.xyy * map(pos + e.xyy) + 
        e.yyx * map(pos + e.yyx) + 
        e.yxy * map(pos + e.yxy) + 
        e.xxx * map(pos + e.xxx));
}

float intersect(in vec3 ro, in vec3 rd)
{
    const float maxd = 35.0;
    const float precis = 0.001;
    float h = 1.0;
    float t = 0.0;
    for(int i = 0; i < 128; i++)
    {
        if(h < precis || t > maxd) break;
        h = map(ro + rd * t);
        t += h;
    }
    if( t > maxd ) t = -1.0;
    return t;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    vec2 p = (2.0 * gl_FragCoord.xy - iResolution.xy) / iResolution.y;
    vec3 col = vec3(length(p) * 0.1);
    col.b += 0.05;
    vec3 ro = vec3(0.0, 0.0, 3.5);
    vec3 rd = normalize(vec3(p, -1.8));
    float t = intersect(ro, rd);
    if(t > -0.001)
    {
        vec3 pos = ro + t * rd;
        vec3 nor = calcNormal(pos);
		vec3 li = normalize(vec3(0.5, 0.8, 3.0));
    	col = vec3(0.8, 0.1, 0.1);
        col *= max(dot(li, nor), 0.2);
        col += pow(max(dot(vec3(0, 0, 1), reflect(-li, nor)), 0.0), 30.0);
        col = pow(col, vec3(0.8)); 
    }
    gl_FragColor = vec4(col, 1.0);
}

