#version 330
#extension GL_EXT_gpu_shader4 : enable
// chrysalisMod01.fsh by   haptix

//https://www.shadertoy.com/view/3dfyRX
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*1.20   //*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

float pi = acos(-1.);
float glo = 0.;

mat2 rot (float rad)
{
    return mat2(cos(rad), sin(rad), -sin(rad), cos(rad));
}

vec2 box(vec3 p, vec3 b, float matId)
{
    vec3 q = abs(p) - b;
    return vec2(length(max(q, 0.)) + min(max(q.x, max(q.y, q.z)), 0.), matId);
}

vec3 kif(vec3 p)
{    
    float t = iTime + 65.;
    
    for(int i = 0; i < 6; i++)
    {
        p.xy *= rot(.061*t);
        
        p = abs(p) - vec3(.05*cos(t*.21) + .31,
                          .05*sin(t*.27) + .35,
                          .05*sin(t*.37) + .37);
        
        p.yz *= rot(.043*t);
    }
    
    return p;
}

vec2 add(vec2 m1, vec2 m2)
{
    return m1.x < m2.x ? m1 : m2;
}

vec2 map(vec3 p)
{   
    p = kif(p);
    
    vec2 m1 = box(p, vec3(.07, .8, 1.), 1.);
    p.x -= .25;
    vec2 m2 = box(p, vec3(.06, .75, .85), 2.);
    p.x += .5;
    vec2 m3 = box(p, vec3(.06, .75, .85), 3.);
    vec2 m = add(m1, m2);
    m = add(m, m3);
    glo += .1 / (.1 + m1.x*m1.x*m1.x*2500.);
    return m;
}

vec2 tr(vec3 ro, vec3 rd)
{
    float far = 15.;
	vec2 h,t= vec2(.01);
	for(int i = 0; i < 384; i++)
	{
		h = map(ro + rd*t.x);
		if(h.x < .00001 || t.x > far)
			break;
		t.x += h.x;
        t.y = h.y;
  	}
    if(t.x > far)
        t.y = 0.;
	return t;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{
	vec3 ro = vec3(.6*cos(-.1*iTime),
                   .91*sin(-.1*iTime),
                   -7.);
	vec3 camTarget = vec3(0.);
	vec3 up = vec3(0., 1., 0.);
	vec3 camDir = normalize(camTarget - ro);
	vec3 camRight = normalize(cross(up, ro));
	vec3 camUp = normalize(cross(camDir, camRight));
    vec3 lightPos = vec3(1.5, 1.5, -30.);
  
	vec2 screenPos = -1. + 2. * gl_FragCoord.xy / iResolution.xy;
	screenPos.x *= iResolution.x / iResolution.y;

	vec2 eps = vec2(0., .01);
	vec3 rd = normalize(camRight*screenPos.x + camUp*screenPos.y + camDir);
  
	vec2 t = tr(ro, rd);

    vec3 colRot = vec3(sin(.317*(iTime + 44.)),
                       sin(.151*(iTime + 55.)),
                       sin(.227*(iTime + 79.))) + 1.2;

    if (t.y > 0.)
    {
        vec3 hit = ro + rd*t.x;
        vec3 lightDir = normalize(lightPos - hit);
        
        vec3 norm = normalize(map(hit).x - vec3(map(hit - eps.yxx).x,
                              					map(hit - eps.xyx).x,
                              					map(hit - eps.xxy).x));
        
        float diff = max(0., dot(lightDir, norm));
        float spec = pow(max(dot(rd, reflect(norm, lightDir)), 0.), 200.);
        float ao = clamp(map(t.x + norm*.5).x / .5, 0., 1.);

        vec3 col = .1 * colRot;
        if(t.y == 2.)
        	colRot = vec3(.2);
        else if(t.y == 3.)
            colRot = vec3(.5);
        
        col *= .12 * ao;
        col += .35 * diff * colRot.yzx;
        col += 1. * spec * vec3(1., 1., 1.);
        col += glo*.008*colRot;
        
        gl_FragColor = vec4(col, 1.);
    }
    else
    	gl_FragColor = vec4(glo*.008*colRot.zyx, 1.);
}