#version 130
#extension GL_EXT_gpu_shader4 : enable
// v3Discs2_glslMod01.fsh  by   jorge2017a1
 
//https://www.shadertoy.com/view/wtXfRM
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
uniform sampler2D iChannel3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract


float saturate(float x) { return clamp(x, 0.0, 1.0); }

float rand(vec2 uv)
{
    return fract(sin(dot(uv, vec2(12.9898, 78.233))) * 43758.5453);
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{
    float scale = iResolution.y / 10.0;
    vec2 p = fragCoord.xy / scale;
    vec2 p1 = fract(p) - 0.5;
    vec2 p2 = fract(p - 0.5) - 0.5;

    float z1 = rand(0.12 * floor(p));
    float z2 = rand(0.23 * floor(p - 0.5));

    float r1 = 0.2 + 0.2 * sin(iTime * 1.9 + z1 * 30.0);
    float r2 = 0.2 + 0.2 * sin(iTime * 1.9 + z2 * 30.0);

    float c1 = saturate((r1 - length(p1)) * scale);
    float c2 = saturate((r2 - length(p2)) * scale);

    float a1 = saturate((r1 + 0.08 - length(p1)) * scale);
    float a2 = saturate((r2 + 0.08 - length(p2)) * scale);

    float c = mix(
        mix(mix(0.0, c1, a1), c2, a2),
        mix(mix(0.0, c2, a2), c1, a1),
        step(z1, z2)
    );

    fragColor = vec4(c, c, c, 1.0);
return fragColor; 
}
///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length ( vec3(1.0) - gl_FragColor.rgb ); //make white transparent
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.