#version 140
#extension GL_EXT_gpu_shader4 : enable
//cilindros-masMod01.fsh by jorge2017a2
//
// Licence CC0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels


#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize


//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D iChannel0;
uniform sampler2D iChannel1;
uniform sampler2D iChannel2;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

//----------image
//por jorge2017a2-
//cilindro mas--29-mar-2022
#define MAX_STEPS 100
#define MAX_DIST 150.
#define MIN_DIST 0.001
#define EPSILON 0.001
#define REFLECT 2
//
//-------common
//#define PI 3.14159265358979323846264
#define PI 3.14159265


///Gracias a Shane...16-jun-2020
vec3 tex3D( sampler2D tex, in vec3 p, in vec3 n ){    
  n = max(n*n - .2, .001); // max(abs(n), 0.001), etc.
  n /= dot(n, vec3(1)); 
  vec3 tx = texture(tex, p.yz).xyz;
  vec3 ty = texture(tex, p.zx).xyz;
  vec3 tz = texture(tex, p.xy).xyz;
  return mat3(tx*tx, ty*ty, tz*tz)*n; 
}

vec3  Arrcolores[] = vec3[] (
vec3(0,0,0),  //0
vec3(1.,1.,1.), //1
vec3(1,0,0),  //2
vec3(0,1,0),   //3
vec3(0,0,1),   //4
vec3(1,1,0),  //5
vec3(0,1,1),  //6 
vec3(1,0,1),   //7

vec3(0.425, 0.56, 0.9) 
);

vec3 getColor(int i)
{ if (i>-1 )  return Arrcolores[i]; }
//
vec3 GetColorYMaterial(vec3 p,  vec3 n, vec3 ro,  vec3 rd, int id_color, float id_material);
vec3 getMaterial( vec3 pp, float id_material);
vec3 light_pos1;  vec3 light_color1 ;
vec3 light_pos2;  vec3 light_color2 ;

//operacion de Union  por FabriceNeyret2
#define opU3(d1, d2) ( d1.x < d2.x ? d1 : d2 )
#define opU2(d1, d2) ( d1.x < d2.x ? d1 : d2 )

float sdSphere( vec3 p, float s )
	{ return length(p)-s;}
float sdCylinderYZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.yz),p.x)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXZ( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xz),p.y)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }
float sdCylinderXY( vec3 p, vec2 h )
	{ vec2 d = abs(vec2(length(p.xy),p.z)) - h; return min(max(d.x,d.y),0.0) + length(max(d,0.0)); }

float opRep1D( float p, float c )
	{ float q = mod(p+0.5*c,c)-0.5*c; return  q ;}

vec3 rotate_x(vec3 p, float phi)
{   float c = cos(phi);	float s = sin(phi);
    return vec3(p.x, c*p.y - s*p.z, s*p.y + c*p.z);
}
vec3 rotate_y(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x + s*p.z, p.y, c*p.z - s*p.x);
}
vec3 rotate_z(vec3 p, float phi)
{	float c = cos(phi);	float s = sin(phi);
	return vec3(c*p.x - s*p.y, s*p.x + c*p.y, p.z);
}


vec2 base01(vec3 p)
{   vec2 res= vec2(9999.0, -1.0);
    float d1a= sdCylinderYZ(p, vec2(2.0,18.0) );  //cilindro principal
    float d1b= sdCylinderYZ(p-vec3( 10.0,0.0,0.0), vec2(3.0,1.0) ); ///anillo 1
    float d1c= sdCylinderYZ(p-vec3(-10.0,0.0,0.0), vec2(3.0,1.0) ); ///anillo 2 
    p.z=abs(p.z)-2.0;
    float d1d= sdCylinderYZ(p-vec3(0.0,0.0,0.0), vec2(0.3,18.0) );
    res =opU2(res, vec2(d1a,100.0));
    res =opU2(res, vec2(d1b,100.0));
    res =opU2(res, vec2(d1c,100.0));
    res =opU2(res, vec2(d1d,101.0));
    return res;
}   

vec2 GetDist(vec3 p  ) 
{	vec2 res= vec2(9999.0, -1.0);  vec3 p0=p;
	float planeDist1 = p.y-1.0;  //piso inf
    p.y=p.y-5.0;
    p.x= opRep1D(p.x,30.0);
    p.y= opRep1D(p.y,30.0);
    p.z= opRep1D(p.z,30.0);
    
    p.z=abs(p.z)-4.0;
    vec2 b1= base01(p);
    res =opU2(res, b1);
    
    p=rotate_z(p, radians(90.0));
    vec2 b2= base01(p);
    res =opU2(res, b2);
    return res;
}

vec3 GetNormal(vec3 p)
{   float d = GetDist(p).x;
    vec2 e = vec2(.001, 0);
    vec3 n = d - vec3(GetDist(p-e.xyy).x,GetDist(p-e.yxy).x,GetDist(p-e.yyx).x);
    return normalize(n);
}

vec2 RayMarch(vec3 ro, vec3 rd, int PMaxSteps)
{   float t = 0.1, tmax = 40.0;
    vec3 p;
    vec2 hit, object=vec2(0.1,0.0);
   for(int i=0; i <= PMaxSteps; i++) 
    { p = ro + rd*object.x;
      hit = GetDist(p);
      object.x += hit.x;
      object.y = hit.y;
      if (abs(hit.x) < EPSILON || object.x > MAX_DIST) break;
    }
    return object;
}

float getSoftShadow(vec3 p, vec3 lightPos) {
    float res = 1.0;
    float dist = 0.01;
    float lightSize = 0.03;
    for (int i = 0; i < MAX_STEPS; i++) {
      float hit = GetDist(p + lightPos * dist).x;
      res = min(res, hit / (dist * lightSize));
      dist += hit;
      if (hit < 0.0001 || dist > 60.0) break;
    }
    return clamp(res, 0.0, 1.0);
}

float occlusion(vec3 pos, vec3 nor)
{   float sca = 2.0, occ = 0.0;
    for(int i = 0; i < 10; i++) {    
      float hr = 0.01 + float(i) * 0.5 / 4.0;
      float dd = GetDist(nor * hr + pos).x;
      occ += (hr - dd)*sca;
      sca *= 0.6;
    }
    return clamp( 1.0 - occ, 0.0, 1.0 );    
}


vec3 lightingv3(vec3 normal,vec3 p, vec3 lp, vec3 rd, vec3 ro,vec3 lightColor, float t) 
{   vec3 lightPos=lp;
    vec3 worldPos = ro + rd * t;
    vec3 V = -rd;
    vec3 N = GetNormal(worldPos);
    vec3 L = normalize (lightPos - worldPos);
    vec3 R = reflect (-L, N);
    
    float lightDist = max(length(L), .001);
    float atten=1.0 / (1.0 + lightDist * 0.125 + lightDist * lightDist * .05);
    L /= (lightDist*atten);

    float shadow = getSoftShadow(worldPos, normalize(lightPos));// shadows
    float occ = occlusion(worldPos, N);// occ
    vec3 ambient= 0.5*lightColor*clamp(0.5 + 0.5*N.y, 0.0, 1.0)*N.y;
    vec3 fresnel =  lightColor *  pow(clamp(1.0 + dot(rd, N), 0.0, 1.0), 2.0);;
    float diff       = clamp(dot(N, L), 0.0, 1.0);
    
    diff = pow(diff, 4.) * 2.;
    vec3 diffuse =  lightColor * diff;
    float shininess=4.0;
    float specular    = pow(max(dot(R, V), 0.0), shininess);
     // back
    vec3 back = 0.5 * lightColor * clamp(dot(N, -L), 0.0, 1.0);
    vec3 colOut = occ*lightColor*(ambient+diffuse*shadow+.35 +back) + vec3(.7,.9,1)*specular*specular;   
    return colOut;
}

//https://www.shadertoy.com/view/WdsGR7
vec3 getColor(float v)
{  float r = cos((v-0.78)*PI*1.66);
   float g = cos((v-0.58)*PI*1.66);
   float b = cos((v-0.28)*PI*1.66);
   return vec3(r,g,b); 
}


vec3 getColorTextura( vec3 p, vec3 nor,  int i)
{	if (i==100 )
    {
        vec3 col;
        if( opRep1D(p.z,60.0)>15.0) 
         col=tex3D(iChannel0, p/32., nor)* getColor(0.78);
        else
         col=tex3D(iChannel0, p/32., nor);
         
        return col*2.0; 
    }
	if (i==101 ) { return tex3D(iChannel1, p/32., nor)*vec3(0.5,1.0,0.5); }
}

vec3 Getluz(vec3 p, vec3 ro, vec3 rd, vec3 nor , vec3 colobj ,vec3 plight_pos, float tdist)
{  float intensity=1.0;
     vec3 result;
    result = lightingv3( nor, p, plight_pos,  rd,ro, colobj, tdist);
    return result;
}

vec3 render_sky_color(vec3 rd)
{   float t = (rd.x + 1.0) / 2.0;
    vec3 col= vec3((1.0 - t) + t * 0.3, (1.0 - t) + t * 0.5, (1.0 - t) + t);
    vec3  sky = mix(vec3(.0, .1, .4)*col, vec3(.3, .6, .8), 1.0 - rd.y);
	return sky;
}

//https://www.shadertoy.com/view/4lcSRn   ///IQ
vec3 pattern( in vec2 uv )
{   vec3 col = vec3(0.4);
    col += 0.4*smoothstep(-0.01,0.02,cos(uv.x*0.5)*cos(uv.y*0.5)); 
    col *= smoothstep(-1.0,-0.98,cos(uv.x))*smoothstep(-1.0,-0.98,cos(uv.y));
    return col;
}

vec3 GetMaterial(vec3 p,  vec3 nor, vec3 ro,  vec3 rd, int id_color)
{  	vec3 colobj; 
     if (id_color<50)
		{ colobj=getColor(int( id_color));  return colobj; }
            
    if (id_color==100 )
   { return  getColorTextura( p, nor,100); }
   
   if (id_color==101 )
   { return  getColorTextura( p, nor,101); }
            
}

vec3 linear2srgb(vec3 c) 
{ return mix(12.92 * c,1.055 * pow(c, vec3(1.0/1.8)) - 0.055, step(vec3(0.0031308), c)); }

vec3 exposureToneMapping(float exposure, vec3 hdrColor) 
{ return vec3(1.0) - exp(-hdrColor * exposure); }

vec3 ACESFilm(vec3 x)
{   float a,b,c,d,e;
    a = 2.51; b = 0.03; c = 2.43;d = 0.59; e = 0.14;
    return (x*(a*x+b))/(x*(c*x+d)+e);
}

vec3 Render(vec3 ro, vec3 rd)
{  vec3 col = vec3(0);
  vec3 p;
     vec2 hit=RayMarch(ro,rd, MAX_STEPS);
      if(hit.x<MAX_DIST) 
       {   p = (ro + rd * hit.x );  
        vec3 nor=GetNormal(p);
        vec3 colobj;
        colobj=GetMaterial( p, nor, ro, rd,  int(hit.y));
        vec3 result;
         result=  Getluz( p,ro,rd, nor, colobj ,light_pos1,hit.x)*light_color1;
        result+= Getluz( p,ro,rd, nor, colobj ,light_pos2,hit.x)*light_color2;
        col= result/2.0;
        col= (ACESFilm(col)+linear2srgb(col)+col+ exposureToneMapping(3.0, col))/4.0 ;
        
    }
    else if(hit.x>MAX_DIST)
    col= render_sky_color(rd);
   return col;
}
void main (void)
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
{  vec2 uv = (gl_FragCoord.xy-.5*iResolution.xy)/iResolution.y;
    float t;
    t=mod(iTime*5.0,360.0);
 	light_pos1= vec3(-10.0, 120.0, 25.); light_color1=vec3( 1.0,1.0,1.0 );
 	light_pos2= vec3(10.0, 20.0, -25.0 ); light_color2 =vec3( 1.0,1.0,1.0 ); 
   vec3 ro=vec3(5.0+t,7.0+t*0.5,-20.0);
   vec3 rd=normalize( vec3(uv.x,uv.y,1.0));
   //rd= rotate_x(rd, radians(25.0));
    light_pos1+=ro;
    light_pos2+=ro;
    vec3 col= Render( ro,  rd);
    gl_FragColor = vec4(col,1.0);
}

